@extends('layouts.production')
@section('addCss')
    {{ HTML::style('plugins/morris/morris.css') }}
    <style media="screen">
        .info-box .info-box-content {
            padding-top: 10px;
        }

        .info-box-text, .info-box-number {
            padding: 5px;
        }
        .inner h3 { font-size: 24px; }
    </style>
@endsection
@section('content')
    <section class="content-header">
        <h1>
            {{ Trans('dashboard.home') }}
            <small>{{ Trans('dashboard.sub_title') }}</small>
        </h1>
        <ol class="breadcrumb">
            <li class="active"><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        @if(Session::has('message'))
            <p class="alert alert-info">
                {{ Session::get('message') }}
            </p>
        @endif
        <div class="row">
            <div class="col-12">
                @include('dashboard.inc.info')
            </div>
        </div>
        @if (get_config("show_remain_principal") == "yes")
        <div class="row">
            <div class="col-md-4 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-aqua"><i class="fa fa-usd"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text">{{ Trans('dashboard.remain_principal') }}</span>
                        <span class="info-box-number">{{money($totalExpense - $totalPaidPrincipal)}}</span>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->
            <div class="col-md-4 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-aqua"><i class="fa fa-money"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">{{ Trans('dashboard.received_principal') }}</span>
                        <span class="info-box-number">
                            {{ money($totalPaidPrincipal) }}
                        </span>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <div class="col-md-4 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-green"><i class="fa fa-money"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">{{ Trans('dashboard.received_interest') }}</span>
                        <span class="info-box-number">
                            {{ money($saleSoFar - $totalPaidPrincipal) }}
                        </span>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
        </div>
        @endif
        @if(get_config('dashboard_chart') == 'yes')
        @include("dashboard.inc.graph")
        @endif
        <div class="row">
            <div class="col-md-4 col-sm-12 col-xs-12 pull-right">
                <div class="box box-solid box-primary">
                    <div class="box-header">
                        <h3 class="box-title"><i class="fa fa-pie-chart "></i>
                            {{ trans("dashboard.monthly_expense_and_income", ['attribute' => this_month()]) }}</h3>
                    </div>
                    <div class="box-body">
                        <div id="canvas-holder" style="width:100%;">
                            <canvas id="chart-area" style="width: 260px; height: 200px;" />
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-8 col-sm-12 col-xs-12 pull-left">
                @include('dashboard.inc.invoices')
            </div>
        </div>
    </section>
@endsection
@section('addJs')
    {{ HTML::script("https://cdn.jsdelivr.net/npm/chart.js@2.7.0/dist/Chart.bundle.js") }}
    {{ HTML::script("https://cdn.jsdelivr.net/npm/chart.js@2.7.0/samples/utils.js") }}
    <script>
        var MONTHS = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        var config = {
            type: 'line',
            data: {
                labels: <?= json_encode($chartData['month']) ?>,
                datasets: [{
                    label: "<?= trans('dashboard.monthly_expense') ?>",
                    fill: false,
                    backgroundColor: window.chartColors.yellow,
                    borderColor: window.chartColors.yellow,
                    data: <?= json_encode($chartData["expense"]) ?>,
                }, {
                    label: "<?= trans('dashboard.monthly_priciple') ?>",
                    backgroundColor: window.chartColors.blue,
                    borderColor: window.chartColors.blue,
                    data: <?= json_encode($chartData['priciple']) ?>,
                    fill: false,
                }, {
                    label: "<?= trans('dashboard.monthly_rate') ?>",
                    fill: false,
                    backgroundColor: window.chartColors.red,
                    borderColor: window.chartColors.red,
                    data: <?= json_encode($chartData["rate"]) ?>,
                }]
            },
            options: {
                responsive: true,
                title: {
                    display: false,
                    text: ''
                },
                tooltips: {
                    mode: 'index',
                    intersect: false,
                },
                hover: {
                    mode: 'nearest',
                    intersect: true
                },
                scales: {
                    xAxes: [{
                        display: true,
                        scaleLabel: {
                            display: true,
                            labelString: "<?= trans('dashboard.months') ?>"
                        }
                    }],
                    yAxes: [{
                        display: true,
                        scaleLabel: {
                            display: true,
                            labelString: "<?= trans('dashboard.money') ?>"
                        }
                    }]
                }
            }
        };
        var configA = {
            type: 'pie',
            data: {
                datasets: [{
                    data: [
                        <?= $monthlyExpense ?>,  <?= $monthlyPrincipal ?>, <?= $monthlyInterest; ?>
                    ],
                    backgroundColor: [
                        window.chartColors.yellow,
                        window.chartColors.green,
                        window.chartColors.red
                    ],
                    label: 'Dataset 1'
                }],
                labels: [
                    "{{ trans('dashboard.monthly_expense_1') }}",
                    "{{ trans('dashboard.monthly_principal') }}",
                    "{{ trans('dashboard.monthly_interest') }}",
                ]
            },
            options: {
                responsive: true
            }
        };
        window.onload = function () {
            var cA = document.getElementById("chart-area").getContext("2d");
            window.myPie = new Chart(cA, configA);
            @if (get_config('dashboard_chart') == 'yes')
            var ctx = document.getElementById("canvas").getContext("2d");
            window.myLine = new Chart(ctx, config);
            @endif
        };
    </script>
@endsection