@extends('layouts.production')
@section('content')
<section class="content-header">
  <h1>
    {{ Trans('customers.menu') }}
    <small>{{ Trans('customers.detail') }}</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li><a href="{{ Route('customers.index') }}"><i class="fa fa-user-plus"></i> {{ Trans('customers.menu') }}</a></li>
    @if(isset($customer) && !empty($customer))
    <li class="active">{{ $customer->first_name }} {{ $customer->last_name }}</li>
    @endif
  </ol>
</section>
<!-- Main content -->
<section class="content">
@include('layouts.includes.message')
<div class="row">
  <div class="col-md-12">
    @if(isset($customer) && !empty($customer))
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">{{ trans('customers.menu')}}</h3>
      </div>
      <div class="box-body">
        <div class="row">
          <div class="col-md-12">
            <!-- /.box-header -->
            <table class="table table-striped table-bordered">
              <tr>
              <th style="width: 30%;"></th>
                <td>
                  {{ HTML::image($customer->photo, $customer->first_name, [
                      'class' => 'img-responsive img-thumbnail',
                      'width' =>  "150px"
                  ]) }}
                </td>
              </tr>
              <tr>
                <th>{{ Trans('customers.name') }}</th>
                <td>{{ $customer->first_name }} {{ $customer->last_name }}</td>
              </tr>
              <tr>
                <th>{{ Trans('customers.sex') }}</th>
                <td>
                  {{  trans('customers.gender.'. $customer->sex) }}
                </td>
              </tr>
              @if (!empty($customer->dob))
              <tr>
                <th>{{ Trans('customers.dob') }}</th>
                <td>{{ $customer->displayDob() }}</td> 
              </tr>
              @endif
              <tr>
                <th>{{ Trans('customers.age') }}</th>
                <td>{{ $customer->age }}</td>
              </tr>
              <tr>
                <th>{{ Trans('customers.tel') }}</th>
                <td>{{ $customer->tel }}</td>
              </tr>
              <tr>
                <th>{{ Trans('customers.id_card') }}</th>
                <td>{{ $customer->id_card }}</td>
              </tr>
              <tr>
                <th>{{ Trans('customers.note') }}</th>
                <td>{{ $customer->note }}</td>
              </tr>
              <tr>
                <th>{{ Trans('customers.address') }}</th>
                <td>{{ $customer->address }}</td>
              </tr>
            </table>
          </div>
        </div>
      </div>
    @endif
    </div>
  </div>
</section>
@endsection
@section('addJs')
  @if(count($invoices)>0)
  <script>
    $(function () {
      $("#example1").DataTable();
      $('#example2').DataTable({
        "paging": true,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false
      });
    });
  </script>
  @endif
@endsection
