<table class="table table-striped" id='example1'>
  <thead>
    <tr>
      <th>{{ trans('quotations.id')}}</th>
      <th>{{ trans('quotations.total_price')}}</th>
      <th>{{ trans('dashboard.others.status')}}</th>
      <th>{{ trans('quotations.created_at')}}</th>
      @if(UserRole::has('detail_quotation') || UserRole::has('delete_quotation'))
      <th>{{ trans('dashboard.crud.actions')}}</th>
      @endif
    </tr>
  </thead>
  <tbody>
    @foreach($quotations as $quotation)
      <tr>
        <td>{{ $quotation->id }}</td>
        <td>{{ money(CustomerQuotation::getTotal($customer->id,$quotation->id)) }}</td>
        <td>{{ $quotation->status }}</td>
        <td>{{ $quotation->created_at }}</td>
        @if(UserRole::has('detail_quotation') || UserRole::has('delete_quotation'))
        <td>
          @if(UserRole::has('detail_quotation'))
          <a href="{{ route('customers.quot', [$customer->id, $quotation->id])}}" class="btn btn-xs btn-info">{{trans('dashboard.others.detail')}}</a>
          @endif
          @if(UserRole::has('delete_quotation'))
          <a href="#" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#myModal{{$quotation->id}}">{{Trans("dashboard.crud.remove")}}</a>
          @include('layouts.includes.modals.danger', ['model' => $quotation,'toRoute'=>'delete.quotation','attribute'=>'id'])
          @endif
        </td>
        @endif
      </tr>
    @endforeach
  </tbody>
</table>
