<!DOCTYPE html>
<html>
<head>
  <title>Quotation</title>
  {{ HTML::style('assets/vendor/bootstrap/dist/css/bootstrap.min.css') }}
  {{-- {{ HTML::style('css/purchase.css') }} --}}
  <style media="screen">
      body {
        padding-top: 20px;
      }
      .container {
        border: 1px solid #ccc;
      }
      table#no-border tr th, table#no-border tr td{
        border: 0 !important;
        padding: 2.5px;
      }
  </style>
  <style media="print">
    @page{
      font-size: 14px;
    }
    table#no-border tr th, table#no-border tr td{
      border: 0 !important;
      padding: 2.5px;
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="row">
      <h2 class="text-center">{{ \Helper::getConfig('company_name')}}</h2>
      <br>
      <div class="col-xs-6 col-sm-6 col-md-6">
        <table id="no-border">
          <tr>
            <th>{{ trans('quotations.address')}}</th>
            <td>:</td>
            <td>{{ \Helper::getConfig('company_address')}}</td>
          </tr>
          <tr>
            <th >{{ trans('quotations.email')}}</th>
            <td>:</td>
            <td>{{ \Helper::getConfig('company_email')}}</td>
          </tr>
          <tr>
            <th>{{ trans('quotations.tel')}}</th>
            <td>:</td>
            <td>{{ \Helper::getConfig('company_tel')}}</td>
          </tr>
          <tr>
            <th>{{ trans('quotations.user_name')}}</th>
            <td>:</td>
            <td>{{ $detail->u_first . ' ' . $detail->u_last }}</td>
          </tr>
        </table>
      </div>
      <div class="col-xs-offset-2 col-sm-offset-2 col-md-offset-2 col-xs-4 col-sm-4 col-md-4">
        <table id="no-border">
          <tr>
            <th>{{ trans('quotations.idq')}}</th>
            <td>:</td>
            <td>#Q{{\InvoiceHelper::convertInvoiceNumber($detail->id)}}</td>
          </tr>
          <tr>
            <th>{{ trans('quotations.created_at')}}</th>
            <td>:</td>
            <td>{{ $detail->created_at }}</td>
          </tr>
          <tr>
            <th>{{ trans('quotations.customer_name')}}</th>
            <td>:</td>
            <td>{{ $detail->first_name. ' '. $detail->last_name}}</td>
          </tr>
          <tr>
            <th>{{ trans('quotations.tel')}}</th>
            <td>:</td>
            <td>{{ $detail->tel }}</td>
          </tr>
        </table>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12">
        <h2 class="text-center">Quotation</h2>
        <table class="table">
          <thead>
            <tr>
              <th>{{ trans('quotations.id')}}</th>
              <th>{{ trans('quotations.barcode')}}</th>
              <th>{{ trans('quotations.product_name')}}</th>
              <th>{{ trans('quotations.quantity')}}</th>
              <th>{{ trans('quotations.unit_price')}}</th>
              <th>{{ trans('quotations.total')}}</th>
            </tr>
          </thead>
          <tbody>
            <?php $i = 1;
            $total = 0;?>
            @foreach($products as $product)
              <?php
                $total += $product->amount * $product->price;
               ?>
              <tr>
                <td>{{ $i++ }}</td>
                <td>{{ $product->sku }}</td>
                <td>{{ $product->name }}</td>
                <td>{{ $product->amount. ' '. $product->unit }}</td>
                <?php $mprice = (Helper::getConfig('invoice_currency') == "riel") ? number_format($product->price*Helper::getConfig('invoice_rate'),0)." &#6107" : number_format($product->price,2)." $"; ?>
  				       <?php $tprice = (Helper::getConfig('invoice_currency') == "riel") ? number_format($product->amount * ($product->price*Helper::getConfig('invoice_rate')),0)." &#6107" : number_format($product->amount * $product->price,2)." $"; ?>
                <td>{{ $mprice }}</td>
                <td>{{ $tprice }}</td>
              </tr>
            @endforeach
            <tr>
              <td colspan="4" rowspan="4" id="merge">
              </td>
              <td><b>{{ trans('quotations.sub_total')}}</b></td>
              <td>
                {{(\Helper::getConfig('invoice_currency') == "riel") ? number_format(riel($total *Helper::getConfig('invoice_rate')),0)." &#6107" : number_format($total,2)." $"}}
              </td>
            </tr>
            <tr>
              <td><b>{{ trans('quotations.tax')}}</b></td>
              <td>{{ \Helper::getConfig('invoice_tax')}} %</td>
            </tr>
            <?php
              $total += $total * (\Helper::getConfig('invoice_tax')/100);
             ?>
            <tr>
              <td><b>{{ trans('quotations.total')}}</b></td>
              <td>{{(Helper::getConfig('invoice_currency') == "riel") ? number_format(riel($total*Helper::getConfig('invoice_rate')),0)." &#6107" : number_format($total,2)." $"}}</td>
            </tr>
            <tr>
              <td>
                <b>{{ (\Helper::getConfig('invoice_currency') == "riel") ? Trans('sale.total')." $" : Trans('sale.total')." &#6107" }}</b>
              </td>
              <td>
                {{(Helper::getConfig('invoice_currency') == "usd") ? number_format(riel($total*Helper::getConfig('invoice_rate')),0)." &#6107" : number_format($total,2)." $"}}
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  {{ HTML::script('assets/vendor/jquery/dist/jquery.min.js') }}
  <script type="text/javascript">
    $(document).ready(function(){
      window.print();
    });
  </script>
</body>
</html>
