@extends('layouts.production')
@section('addCss')
<style media="screen">
input[type=number].form-control {
 width: 50%;
}
</style>
@endsection
@section('content')
<section class="content-header">
  <h1>
    {{ Trans('quotations.menu') }}
    <small>{{ Trans('customers.show') }}</small>
    <span id="customer_quot_id" data-customer-quot-id="{{\Helper::getCustomerQuotID($customer->id)}}"></span>
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li><a href="{{ route('customers.index') }}"><i class="fa fa-user-plus"></i> {{ Trans('customers.menu') }}</a></li>
    <li><a href="{{ route('customers.show', $customer->id)}}">{{ $customer->fullName() }}</a></li>
    <li class="active">{{ Trans('quotations.menu') }}</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
@include('layouts.includes.message')
@include('Customers.quotations.url')
<div class="row">
  <div class="col-md-12">
    <div class="box">
      <!-- /.box-header -->
      <div class="box-body">
        <table id="example1" class="table table-bordered table-striped">
        </table>
        </div>
        <!-- /.box-body -->
      </div>
      <!-- /.box -->
    </div>
    <div class="col-md-12">
      <div class="box">
        @include('Customers.quotations.alert')
        @include('Customers.quotations.table_order')
      </div>
    </div>
  </div>
</section>
@endsection
@section('addJs')
{{ HTML::script("plugins/datatables/jquery.dataTables.min.js") }}
{{ HTML::script('plugins/datatables/dataTables.bootstrap.min.js') }}
<script>
      $(function () {
        $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });
        $("#example1").DataTable({
          "ajax"        : "{{Route('getProductsInStock')}}",
          "processing"  : true,
          "serverSide"  : true,
          "paging": true,
          "autoWidth": false,
          "columnDefs": [
            { "searchable": false, "targets": 5 },
            { "searchable": false, "targets": 6 }
          ],
          "columns": [
              {data: 'id', name: 'Products.id',title: '{{trans('products.sku')}}'},
              {data: 'name', name: 'Products.name',orderable: false,title: '{{trans('products.name')}}'},
              {data: 'name_kh', name: 'Products.name_kh',orderable: false,title: '{{trans('products.name_kh')}}'},
              {data: 'amount', name: 'Products.amount',orderable: false,title: '{{trans('products.amount')}}'},
              {data: 'price', name: 'Products.price',orderable: false,title: '{{trans('products.price')}}'},{data: 'qty', name: 'qty',orderable: false,title: '{{trans('products.amount')}}' },
              {data: 'action', name: 'action',orderable: false,title: '{{trans('dashboard.crud.actions')}}'}
          ],
          initComplete: function () {
            this.api().columns([1,2,3]).every(function () {
                var column = this;
                var input = document.createElement("input");
                $(input).appendTo($(column.footer()).empty())
                .on('change', function () {
                    var val = $.fn.dataTable.util.escapeRegex($(this).val());
                    column.search(val ? val : '', true, false).draw();
                });
            });
          }
        });
      });
    </script>
{{ HTML::script('js/quotation.js') }}
<script type="text/javascript">
  $(document).ready(function() {
    quotation.listItem();
    quotation.cancelOrder();
    //quotation.submitQuotation();
  });
</script>
@endsection
