@extends('layouts.production')
@section('addCss')
<style media="screen">
input[type=number].form-control {
 width: 50%;
}
</style>
@endsection
@section('content')
<section class="content-header">
  <h1>
    {{ Trans('quotations.menu') }}
    <small>{{ Trans('customers.detail') }}</small>
    <span id="customer_quot_id" data-customer-quot-id="{{ $customer_quot->id }}"></span>
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li><a href="{{ route('customers.index') }}"><i class="fa fa-user-plus"></i> {{ Trans('customers.menu') }}</a></li>
    <li><a href="{{ route('customers.show', $customer->id)}}">{{ $customer->fullName() }}</a></li>
    <li class="active">{{ Trans('quotations.menu') }}</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
@include('layouts.includes.message')
@include('Customers.quotations.url')
<div class="row">
  <div class="col-md-12">
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">{{ trans('quotations.product')}}</h3>
        <a href="{{ route('customers.quotprint', [$customer->id, $customer_quot->id]) }}" class="btn btn-xs btn-info pull-right" target="_blank"><i class="fa fa-print"></i> {{ trans('reports.print')}}</a>
      </div>
      <!-- /.box-header -->
      <div class="box-body">
        <table id="example1" class="table table-striped table-bordered">
          <thead>
            <tr>
              <th>{{ trans('products.id')}}</th>
              <th>{{ trans('products.sku')}}</th>
              <th>{{ trans('products.name')}}</th>
              <th>{{ trans('products.amount')}}</th>
              <th>{{ trans('products.price')}}</th>
              <th>{{ trans('invoices.total')}}</th>
              <th>{{ trans('dashboard.crud.actions')}}</th>
            </tr>
          </thead>
          <tbody id='data'>
          </tbody>
        </table>
        </div>
        <!-- /.box-body -->
      </div>
      <!-- /.box -->
    </div>
</section>
@endsection
@section('addJs')
  {{ HTML::script('js/quotation.js')}}
  <script type="text/javascript">
    $(document).ready(function() {
      quotation.listItem();
    });
  </script>
@endsection
