<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Invoice V1</title>
	{{ HTML::style('css/installment.css') }}
    <style media="print">
    @page {
        size: A4;
        margin-top: 10px !important;
        margin: 10px;
        margin-left: 10px;

    }
    body { font-size: 12px !important; color: #000 !important; }
    img { width: 150px !important; }
    hr { border-color: #333333!important; margin-top: 0; margin-bottom: 0;}
        /*.table-nobordered { border: 1px solid #333333 !important; }*/
        .table-nobordered th, .table-nobordered td { border: 0 !important;  padding: 5px; color: #000 !important;}
        .table-nobordered { margin-bottom: 5px; }
        table, th, td { border-color: #333333 !important; padding: 5px !important; color: #000 !important;}
        th { border-bottom-width: 1px !important;}
        h2 { font-family: "Khmer OS Muol";}
        h2, h3, p { text-align: center; }
        h2 { font-size: 22px !important; margin-bottom: 5px !important; }
        h3 { font-size: 18px !important; margin-top: 0 !important; }
        p { margin: 5px !important; color: #000 !important;}
        table.table-paid{
            border: 1px solid #333;
        }
        table th { font-weight: bold !important; }
        .table-paid th, .table-paid td{
            border: 1px solid #333;
        }
        .table-paid tr td:last-child{
            border-right: none;
        }
        .strike-trough{
            position: relative;
        }
        .strike-trough:after{
            content: '';
            display: block;
            border-bottom: 1px solid #333;
            right: 0;
            position: absolute;
            left: 0;
            padding-top: 20px;
            margin-left: 15px;
            margin-right: 15px;
        }
        .logo { padding-top: 30px; padding-bottom: 40px; }
    </style>
    <style>
        hr { border-color: #333333!important; margin-top: 0; margin-bottom: 0;}
        /*.table-nobordered { border: 1px solid #333333 !important; }*/
        .table-nobordered th, .table-nobordered td { border: 0 !important; }
        table, th, td { border-color: #333333 !important;}
        th { border-bottom-width: 1px !important;}
        h2 { font-family: "Khmer OS Muol";}
        h2, h3, p { text-align: center; }
        table.table-paid{
            border: 1px solid #333;
        }
        .table-paid th, .table-paid td{
            border: 1px solid #333;
        }
        .table-paid tr td:last-child{
            border-right: none;
        }
        .strike-trough{
            position: relative;
        }
        .strike-trough:after{
            content: '';
            display: block;
            border-bottom: 1px solid #333;
            right: 0;
            position: absolute;
            left: 0;
            padding-top: 20px;
            margin-left: 15px;
            margin-right: 15px;
        }
        .logo { padding-top: 30px; padding-bottom: 40px; }
		.company_banner {
			padding: 5px;}
		.installment-title { border-bottom: 1px solid #000; padding-bottom: 5px; }
        .header { text-align: center;}
        .header p { margin-bottom: 5px !important;}
		{{ get_config("custom_style") }}
    </style>
</head>

<body>
	<div class="container-fluid">
		<div class="row">
			<div class="col-xs-3" >
				{{ HTML::image(get_config('company_logo'), "Logo", ['width' => '200px;', 'class' => 'logo'])}}
			</div>
			<div class="col-xs-6">
				<div class="header">
                    <h2>{{ get_config('company_name') }}</h2>
                    <h3 style="margin-top: 10px; text-transform: uppercase;">{{ get_config('company_name_en') }}</h3>
                    <p>{{ get_config('company_detail') }}</p>
                    <p>{{ get_config('company_address')}}</p>
                    <p>លេខទូរស័ព្ទ: {{ get_config('company_tel')}}</p>
                    @if (get_config('company_facebook'))
                        <p>Facebook: {{ get_config("company_facebook") }}</p>
                    @endif
                </div>
			</div>
            <div class="col-xs-3">
				@if(!empty(get_config('company_banner')))
					{{ HTML::image(get_config('company_banner'), "Banner", [
						'class' => 'pull-right company_banner img-responsive'
					]) }}
				@else
          {{ HTML::image('uploads/img.jpg', "IMG", ['class' => 'pull-right company_banner']) }}
				@endif
            </div>
		</div>

		<div class="row">
			<div class="col-xs-12">
				<h3 class="text-left installment-title">{{ trans('installments.menu') }}</h3><br/>
				<table class="table table-bordered table-striped ">
					<tr>
						<th>{{ Trans('customers.name') }}</th>
                        <td>{{ $customer->first_name }} {{ $customer->last_name }}</td>
                        <th>{{ trans('customers.sex') }}</th>
                        <td>{{ trans('customers.gender.'.$customer->gender)}}</td>
                        <th>{{ Trans('customers.dob') }}</th>
                        <td>{{ $customer->dob }}</td>
					</tr>
					<tr>
						<th>{{ trans('customers.tel') }}</th>
                        <td>{{ $customer->tel }}</td>
                        <th>{{ Trans('customers.age') }}</th>
                        <td>{{ $customer->age }}</td>
                        <th>{{ Trans('customers.id_card') }}</th>
                        <td>{{ $customer->id_card }}</td>
                    </tr>
                    <tr>
                        <th>{{ Trans('customers.address') }}</th>
                        <td>{{ $customer->address }}</td>
                    </tr>
                    
                    
                </table>
                <h3 class="text-left installment-title">{{ trans('installments.waranty_info') }}</h3>
                <table class="table table-bordered table-striped ">
					<tr>
						<th>{{ Trans('customers.name') }}</th>
                        <td>{{ $guarantor->g_full_name_kh }} {{ $guarantor->g_full_name_en }}</td>
                        <th>{{ trans('customers.sex') }}</th>
                        <td>{{ trans('customers.gender.'.$guarantor->gender)}}</td>
                        <th>{{ Trans('customers.dob') }}</th>
                        <td>{{ $guarantor->dob }}</td>
					</tr>
					<tr>
						<th>{{ trans('customers.tel') }}</th>
                        <td>{{ $guarantor->g_tel }}</td>
                        <th>{{ Trans('customers.age') }}</th>
                        <td>{{ $guarantor->age }}</td>
                        <th>{{ Trans('customers.id_card') }}</th>
                        <td>{{ $guarantor->g_id_card_no }}</td>
                    </tr>
                    <tr>
                        <th>{{ Trans('customers.address') }}</th>
                        <td>{{ $customer->address }}</td>
                    </tr>
                    <tr>
                        <th>{{ Trans('customers.note') }}</th>
                        <td>{{ $customer->note }}</td>
                    </tr>
                </table>
			</div>
		</div>
	</div>
   
</body>
<script>
	window.print();
</script>
@if (get_config('auto_close_print') == 'yes')
<script>
    window.close();
</script>
@endif
</html>
