@extends('layouts.production')
@section('addCss')
    <style media="screen">
        fieldset {
            border: 1px solid #ddd !important;
            padding: 10px;
            margin-bottom: 20px;
        }
        legend { font-size: 14px; border-bottom: 0; width: inherit; border: 1px solid #ddd; padding: 5px; margin-bottom: 0;}
    </style>
@endsection
@section('content')
<section class="content-header">
  <h1>
    {{ Trans('customers.menu') }}
    <small>{{ Trans('customers.show') }}</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li><a href="{{ Route('loan_customers.index') }}"><i class="fa fa-user-plus"></i> {{ Trans('customers.menu') }}</a></li>
    <li class="active">{{ Trans('customers.show') }}</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
@include('layouts.includes.message')
<div class="row">
  <div class="col-md-12">
    <div class="box">
    {{ Form::open(['route' => 'loan_customers.store', "files" => true]) }}
    <div class="box-header with-border">
        <h3 class="box-title">{{ trans("customers.add") }}</h3>
    </div>
    <div class="box-body">
        @include('customers.form.customer')
    </div>
     <div class="box-footer">
         <div class="col-md-9">
             <div class="pull-right">
                 <button type="reset" name="reset" class="btn btn-defaul">{{ trans('dashboard.crud.cancel') }}</button>
                 <button type="submit" name="button" class="btn btn-primary">{{ trans('dashboard.crud.add') }}</button>
             </div>
         </div>
      {{ Form::close() }}
     </div>
    </div>
  </div>
 </div>
</section>
@endsection
@section('addJs')
{{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
{{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
{{ HTML::script('https://pixlcore.com/demos/webcamjs/webcam.min.js')}}
{{ HTML::script('production/js/webcam.js') }}
<script>
  $('#dob, #date_of_stay').datepicker({
    format: "dd/mm/yyyy",
    todayHighlight: true
  });
</script>
@endsection
