@extends('layouts.production')
@section('content')
<section class="content-header">
  <h1>
    {{ Trans('customers.menu') }}
    <small>{{ Trans('customers.show') }}</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li><a href="{{ Route('customers.index') }}"><i class="fa fa-user-plus"></i> {{ Trans('customers.menu') }}</a></li>
    <li class="active">{{ Trans('customers.show') }}</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
@include('layouts.includes.message')
<div class="row">
  <div class="col-md-12">
    <div class="box">
      <!-- /.box-header -->
      <div class="box-body">
        <table id="example1" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>{{ trans('customers.id') }}</th>
                    <th colspan="2">{{ trans('customers.name') }}</th>
                    <th>{{ trans('customers.sex') }}</th>
                    <th>{{ trans('customers.tel') }}</th>
                    <th style="width: 20%;">{{ trans('dashboard.crud.actions') }}</th>
                </tr>
            </thead>
        </table>
        </div>
      </div>
      <!-- /.box -->
    </div>
  </div>
</section>
@endsection
@section('addJs')
<script>
    $(function () {
      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
      $("#example1").DataTable({
        "ajax"        : "{{Route('getCustomers')}}",
        "processing"  : true,
        "serverSide"  : true,
        "paging": true,
        "autoWidth": false,
        "columnDefs": [
          { "searchable": false, "targets": 5 }
        ],
        "columns": [
            {data: 'id', name: 'id', orderable: false},
            {data: 'first_name', name: 'first_name',orderable: false},
            {data: 'last_name', name: 'last_name',orderable: false},
            {data: 'sex', name: 'sex',orderable: false,},
            {data: 'tel', name: 'tel',orderable: false,},
            {data: 'action', name: 'action',orderable: false}

        ],
        initComplete: function () {
          this.api().columns([1,2,3]).every(function () {
              var column = this;
              var input = document.createElement("input");
              $(input).appendTo($(column.footer()).empty())
              .on('change', function () {
                  var val = $.fn.dataTable.util.escapeRegex($(this).val());
                  column.search(val ? val : '', true, false).draw();
              });
          });
        }
      });
    });
  </script>
@endsection
