<div class="row">
  <div class="col-md-9">
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">{{ trans('customers.form') }} {{ trans('customers.menu') }}</h3>
      </div>
      <div class="box-body">
        <div class="row">
          <div class="col-md-4 form-group">
            @if (!empty(Input::get('installment_id')))
                {{ Form::hidden('installment_id', Input::get('installment_id')) }}
            @endif
            {{ Form::label('first_name', Trans('customers.first_name')) }}
            {{ Form::text('first_name', null, [
              'class' => 'form-control',
              'placeholder' => Trans('customers.first_name'),
              'required' => "required"
            ]) }}
          </div>
          <div class="col-md-4 form-group">
            {{ Form::label('last_name', Trans('customers.last_name')) }}
            {{ Form::text('last_name', null, [
              'class' => 'form-control',
              'placeholder' => Trans('customers.last_name'),
              'required' => "required"
            ]) }}
          </div>
          <?php
            if(App::getLocale() == "kh") {
              $sex = [
                'm' => 'ប្រុស',
                'f' => 'ស្រី',
              ];
            }
            else {
              $sex = [
                'm' => 'Male',
                'f' => 'Female',
              ];
            }
          ?>
          <div class="col-md-4 form-group">
            <?php
            $selected = isset($customer) ? $customer->sex : "";
             ?>
            {{ Form::label('sex', Trans('customers.sex')) }}
            {{ Form::select('sex', $sex, $selected, ['class' => 'form-control select2']) }}
          </div>
        </div>
        <div class="row">
            <div class="col-md-4 form-group">
              {{ Form::label('dob',Trans("users.dob")) }}
              <div class="input-group date" data-provide="datepicker">
                {{ Form::text('dob', null, [
                  'class' => "form-control",
                  'placeholder' => Trans("users.dob")
                ]) }}
                <div class="input-group-addon">
                    <i class="fa fa-calendar-o"></i>
                </div>
              </div>
            </div>
          <div class="col-md-4 form-group">
            {{ Form::label('age', Trans('customers.age')) }}
            {{ Form::number('age', null, [
              'class' => 'form-control',
              'placeholder' => Trans('customers.age')
            ]) }}
          </div>
          <div class="col-md-4 form-group">
            {{ Form::label('tel', Trans('customers.tel')) }}
            {{ Form::text('tel', null, [
              'class' => 'form-control',
              'placeholder' => Trans('customers.tel'),
              'required' => "required"
            ]) }}
            @if(isset($errors))
              <span class="help-inline text-danger">{{ $errors->first('tel')}}</span>
            @endif
          </div>
        </div>
        <div class="row">
            <div class="col-md-4 form-group">
              {{ Form::label('id_card', Trans('customers.id_card')) }}
              {{ Form::text('id_card', null, [
                'class' => 'form-control',
                'placeholder' => Trans('customers.id_card'),
              ]) }}
            </div>
          <div class="col-md-4 form-group">
            {{ Form::label('address', Trans('customers.address')) }}
            {{ Form::textarea('address', null, [
              'class' => "form-control",
              'placeholder' => Trans('customers.address'),
              'rows' => '2'
            ]) }}
          </div>
          <div class="col-md-4 form-group">
            {{ Form::label('note', Trans('customers.note')) }}
            {{ Form::textarea('note', null, [
              'class' => "form-control",
              'placeholder' => Trans('customers.note'),
              'rows' => '2'
            ]) }}
          </div>

        </div>
        <div class="row">
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="form-group pull-right">
              <button type="submit" name="submit" class="btn btn-primary">
                @if(isset($customer->id))
                  {{ Trans('dashboard.crud.update') }}
                @else
                  {{ Trans('dashboard.crud.add') }}
                @endif
              </button>
              <button type="reset" name="button" class="btn btn-default">{{ Trans('dashboard.crud.reset') }}</button>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
  <div class="col-md-3">
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">{{ trans('customers.photo') }}</h3>
      </div>
      <div class="box-body">
        @if (isset($customer->id))
            <img src="{{$customer->photo}}" alt="{{ $customer->fullName() }}" class="img img-thumbnail img-responsive">
            <br><br>
        @endif
        <div class="form-group">
          {{ Form::label('photo', Trans('customers.photo')) }}
          {{ Form::file('photo', [
            'class' => "form-control",
          ]) }}
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="form-group">
              <div id="my_camera"></div>
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-group">
              <div id="results" class="preview-area"></div>
            </div>
          </div>
        </div>
        <textarea id="image_name" name="image_name" style="display:none;"></textarea>
        <div class="form-group">
          <button type="button" onClick="preview_snapshot()" class="preview_snapshot btn btn-success"><i class="fa fa-play-circle-o"></i> {{Trans("users.take_snapshot")}}</button>
          <button type="button" onClick="start_webcam()" class="start_webcam btn btn-default"><i class="fa fa-camera"></i> {{Trans("users.start_webcam")}}</button>
          <button type="button" onClick="closeWebCam()" class="cancel_preview btn btn-danger"><i class="fa fa-stop"></i> Stop</button>
        </div>
      </div>
    </div>
  </div>
</div>
