<div class="row">
  <div class="col-md-3 form-group">
    {{ Form::label('first_name', Trans('customers.first_name')) }}
    {{ Form::text('first_name', null, [
      'class' => 'form-control',
      'placeholder' => Trans('customers.first_name'),
      'required' => "required"
    ]) }}
  </div>
  <div class="col-md-3 form-group">
    {{ Form::label('last_name', Trans('customers.last_name')) }}
    {{ Form::text('last_name', null, [
      'class' => 'form-control',
      'placeholder' => Trans('customers.last_name'),
      'required' => "required"
    ]) }}
  </div>
  <?php
    if(App::getLocale() == "kh") {
      $sex = [
        'Male' => 'ប្រុស',
        'Female' => 'ស្រី',
        "Other" => 'ផ្សេងៗ'
      ];
    }
    else {
      $sex = [
        'Male' => 'Male',
        'Female' => 'Female',
        "Other" => 'Other'
      ];
    }
  ?>
  <div class="col-md-3 form-group">
    <?php
    $selected = isset($customer) ? $customer->sex : "";
     ?>
    {{ Form::label('sex', Trans('customers.sex')) }}
    {{ Form::select('sex', $sex, $selected, ['class' => 'form-control']) }}
  </div>
  <div class="col-md-3 form-group">
    <?php
    $selected = isset($customer) ? $customer->branch_id : "";
     ?>
    {{ Form::label('branch_id', Trans('customers.branch')) }}
    {{ Form::select('branch_id', $branches, $selected, ['class' => 'form-control']) }}
  </div>
</div>
<div class="row">
  <div class="col-md-3 form-group">
    {{ Form::label('email', Trans('customers.email')) }}
    {{ Form::email('email', null, [
      'class' => 'form-control',
      'placeholder' => Trans('customers.email')
    ]) }}
    @if(isset($errors))
      <span class="help-inline text-danger">{{ $errors->first('email')}}</span>
    @endif

  </div>
  <div class="col-md-3 form-group">
    {{ Form::label('tel', Trans('customers.tel')) }}
    {{ Form::text('tel', null, [
      'class' => 'form-control',
      'placeholder' => Trans('customers.tel'),
      'required' => "required"
    ]) }}
    @if(isset($errors))
      <span class="help-inline text-danger">{{ $errors->first('tel')}}</span>
    @endif
  </div>
  <div class="col-md-3 form-group">
    {{ Form::label('age', Trans('customers.age')) }}
    {{ Form::number('age', null, [
      'class' => 'form-control',
      'placeholder' => Trans('customers.age'),
      'required' => "required"
    ]) }}
  </div>
  <div class="col-md-3 form-group">
    {{ Form::label('photo', Trans('customers.photo')) }}
    {{ Form::file('photo', [
      'class' => "form-control"
    ]) }}
  </div>
</div>
<div class="row">
  <div class="col-md-6 form-group">
    {{ Form::label('note', Trans('customers.note')) }}
    {{ Form::textarea('note', null, [
      'class' => "form-control",
      'placeholder' => Trans('customers.note'),
      'rows' => '4'
    ]) }}
  </div>
  <div class="col-md-6 form-group">
    {{ Form::label('address', Trans('customers.address')) }}
    {{ Form::textarea('address', null, [
      'class' => "form-control",
      'placeholder' => Trans('customers.address'),
      'rows' => '4'
    ]) }}
  </div>
</div>
<div class="row">
  <div class="col-md-12">
    {{ Form::label('photo', Trans("users.use_webcam_photo")) }}
  </div>
  <div class="col-md-3">
    <div id="my_camera"></div>
  </div>
  <div class="col-md-3 preview-area">
     <div id="results"></div>
  </div>
  <textarea id="image_name" name="image_name" style="display:none;"></textarea>
</div>
<div class="row webcam-tools">
  <div class="col-md-6">
    <input type=button value="{{Trans("users.take_snapshot")}}" onClick="preview_snapshot()" class="preview_snapshot">
    <input type=button value="{{Trans("users.start_webcam")}}" onClick="start_webcam()" class="start_webcam">
    <input type=button value="Stop" onClick="closeWebCam()" class="cancel_preview">
  </div>
  <div class="col-md-6">
    <div class="pull-right">
      <button type="submit" name="submit" class="btn btn-primary">
        @if(isset($customer->id))
          {{ Trans('dashboard.crud.update') }}
        @else
          {{ Trans('dashboard.crud.add') }}
        @endif
      </button>
      <button type="reset" name="button" class="btn btn-default">{{ Trans('dashboard.crud.reset') }}</button>
    </div>
  </div>
</div>
