<div class="row">
    <div class="col-md-9">
        <div class="row">
             <div class="col-md-3 form-group {{ $errors->has('full_name_kh') ? ' has-error' : '' }}">
               {{ Form::label('full_name_kh', Trans('customers.full_name_kh')) }} <span class="required">*</span>
               {{ Form::text('full_name_kh', null, [
                 'class' => 'form-control',
                 'placeholder' => Trans('customers.full_name_kh'),
               ]) }}
               <small class="text-danger">{{ $errors->first('full_name_kh') }}</small>
             </div>
             <div class="col-md-3 form-group {{ $errors->has('full_name_en') ? ' has-error' : '' }}">
               {{ Form::label('full_name_en', Trans('customers.full_name_en')) }} <span class="required">*</span>
               {{ Form::text('full_name_en', null, [
                 'class' => 'form-control',
                 'placeholder' => Trans('customers.full_name_en'),
               ]) }}
               <small class="text-danger">{{ $errors->first('full_name_en') }}</small>
             </div>
             <div class="col-md-3 form-group">
               {{ Form::label('gender', Trans('customers.sex')) }}
               {{ Form::select('gender', [
                   'm' =>  trans('customers.gender.m'),
                   'f' =>  trans('customers.gender.f')
               ], null, ['class' => 'form-control select2']) }}
             </div>
             <div class="col-md-3 form-group">
               {{ Form::label('marital_status', Trans('customers.marital_status.label')) }}
               {{ Form::select('marital_status', [
                   'single' =>  trans('customers.marital_status.single'),
                   'married' =>  trans('customers.marital_status.married')
               ], null, ['class' => 'form-control select2']) }}
             </div>
        </div>
        <div class="row">
             <div class="col-md-3 form-group">
               {{ Form::label('nationality', Trans('customers.nationality.label')) }}
               {{ Form::select('nationality', [
                   'khmer' =>  trans('customers.nationality.khmer'),
                   'others' =>  trans('customers.nationality.others')
               ], null, ['class' => 'form-control select2']) }}
             </div>
               <div class="col-md-3 form-group">
                 {{ Form::label('dob',Trans("users.dob")) }}
                 <div class="input-group date">
                 <?php $selected =  $loanCustomer->dob ? d_format($loanCustomer->dob) : null; ?>
                   {{ Form::text('dob', $selected, [
                       'class' => 'form-control',
                       'id'    => "dob",
                       'placeholder'    =>  trans('customers.dob')
                   ]) }}
                   <div class="input-group-addon">
                       <i class="fa fa-calendar-o"></i>
                   </div>
                 </div>
               </div>
               <div class="col-md-3 form-group {{ $errors->has('id_card_no') ? ' has-error' : '' }}">
                   {{ Form::label('id_card_no', Trans('customers.id_card')) }} <span class="required">*</span>
                   {{ Form::text('id_card_no', null, [
                     'class' => 'form-control',
                     'placeholder' => Trans('customers.id_card'),
                   ]) }}
                   <small class="text-danger">{{ $errors->first('id_card_no') }}</small>
               </div>
             <div class="col-md-3 form-group {{ $errors->has('tel') ? ' has-error' : '' }}">
               {{ Form::label('tel', Trans('customers.tel')) }} <span class="required">*</span>
               {{ Form::text('tel', null, [
                 'class' => 'form-control',
                 'placeholder' => Trans('customers.tel'),
               ]) }}
               <small class="text-danger">{{ $errors->first('tel') }}</small>
             </div>
         </div>
        <div class="row">
           <div class="col-md-12">
               <fieldset>
                   <legend>{{ trans('customers.education.label') }}</legend>
                   <div class="col-md-3">
                       <div class="radio">
                          <label>
                            <input type="radio" name="education" value="primary_school" {{ $loanCustomer->education == "primary_school" ? 'checked="checked"' : "" }}> {{ trans('customers.education.primary_school') }}
                          </label>
                        </div>
                   </div>
                   <div class="col-md-3">
                       <div class="radio">
                          <label>
                            <input type="radio" name="education" value="high_school" {{ $loanCustomer->education == "high_school" ? 'checked="checked"' : "" }}> {{ trans('customers.education.high_school') }}
                          </label>
                        </div>
                   </div>
                   <div class="col-md-3">
                      <div class="radio">
                          <label>
                            <input type="radio" name="education" value="college" {{ $loanCustomer->education == "college" ? 'checked="checked"' : "" }}> {{ trans('customers.education.college') }}
                          </label>
                        </div>
                   </div>
                   <div class="col-md-3">
                       <div class="radio">
                           <label>
                            <input type="radio" name="education" value="others" {{ $loanCustomer->education == "others"  ? 'checked="checked"' : "" }}>
                             {{ Form::text('other_education', null, [
                              'class' => 'form-control',
                              'placeholder' => Trans('customers.education.others'),
                            ]) }}
                           </label>
                         </div>

                   </div>
               </fieldset>
           </div>

        </div>

         <div class="row">
             <div class="col-md-12">
                 <fieldset>
                     <legend>{{ trans('customers.address') }}</legend>
                    <div class="row">
                        <div class="col-md-3 form-group">
                            {{ Form::label('house_number', Trans('customers.location.home_number')) }}
                            {{ Form::text('house_number', null, [
                              'class' => 'form-control',
                              'placeholder' => Trans('customers.location.home_number'),
                            ]) }}
                        </div>
                        <div class="col-md-3 form-group">
                            {{ Form::label('road_number', Trans('customers.location.road_number')) }}
                            {{ Form::text('road_number', null, [
                              'class' => 'form-control',
                              'placeholder' => Trans('customers.location.road_number'),
                            ]) }}
                        </div>
                        <div class="col-md-3 form-group">
                            {{ Form::label('group_number', Trans('customers.location.group_numner')) }}
                            {{ Form::text('group_number', null, [
                              'class' => 'form-control',
                              'placeholder' => Trans('customers.location.group_numner'),
                            ]) }}
                        </div>
                        <div class="col-md-3 form-group">
                            {{ Form::label('village', Trans('customers.location.village')) }}
                            {{ Form::text('village', null, [
                              'class' => 'form-control',
                              'placeholder' => Trans('customers.location.village'),
                            ]) }}
                        </div>
                    </div>
                    <div class="row">
                       <div class="col-md-4 form-group">
                           {{ Form::label('commune', Trans('customers.location.commune')) }}
                           {{ Form::text('commune', null, [
                             'class' => 'form-control',
                             'placeholder' => Trans('customers.location.commune'),
                           ]) }}
                       </div>
                       <div class="col-md-4 form-group">
                           {{ Form::label('district', Trans('customers.location.district')) }}
                           {{ Form::text('district', null, [
                             'class' => 'form-control',
                             'placeholder' => Trans('customers.location.district'),
                           ]) }}
                       </div>
                       <div class="col-md-4 form-group">
                           {{ Form::label('province', Trans('customers.location.province')) }}
                           {{ Form::text('province', null, [
                             'class' => 'form-control',
                             'placeholder' => Trans('customers.location.province'),
                           ]) }}
                       </div>
                    </div>
                 </fieldset>
             </div>
         </div>
         <div class="row">
             <div class="col-md-4">
                 {{ Form::label('property', Trans('customers.property.label')) }}
                 {{ Form::select('property', [
                     'owner'   =>  trans('customers.property.owner'),
                     'parents'   =>  trans('customers.property.parents'),
                     'sibling'   =>  trans('customers.property.sibling'),
                     'rent_house'   =>  trans('customers.property.rent_house'),
                     'others'   =>  trans('customers.property.others')
                 ], null, ['class' => 'form-control select2']) }}
             </div>
             <div class="col-md-4">
                 {{ Form::label('date_of_stay',Trans("customers.date_of_stay")) }}
                 <div class="input-group date">
                     <?php $selected =  $loanCustomer->date_of_stay ? d_format($loanCustomer->date_of_stay) : null; ?>
                     {{ Form::text('date_of_stay', $selected, [
                         'class' => 'form-control',
                         'id'    => 'date_of_stay',
                         'placeholder'    =>  trans('customers.date_of_stay')
                     ]) }}
                   <div class="input-group-addon">
                       <i class="fa fa-calendar-o"></i>
                   </div>
                 </div>
             </div>
             <div class="col-md-4">
                 {{ Form::label('live_with', Trans('customers.live_with.label')) }}
                 {{ Form::select('live_with', [
                     'parents'   =>  trans('customers.live_with.parents'),
                     'wife'   =>  trans('customers.live_with.wife'),
                     'sibling'   =>  trans('customers.live_with.sibling'),
                     'friend'   =>  trans('customers.live_with.friend'),
                     'single'   =>  trans('customers.live_with.single'),
                     'others'   =>  trans('customers.live_with.others')

                 ], null, ['class' => 'form-control select2']) }}
             </div>
         </div>
    </div>
    <div class="col-md-3">
        @if (isset($loanCustomer->id))
            <img src="{{imgUrl($loanCustomer->photo)}}" alt="{{ $loanCustomer->full_name_kh }}" class="img img-thumbnail img-responsive">
            <br><br>
        @endif
        <div class="form-group">
          {{ Form::label('photo', Trans('customers.photo')) }}
          {{ Form::file('photo', [
            'class' => "form-control",
          ]) }}
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="form-group">
              <div id="my_camera"></div>
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-group">
              <div id="results" class="preview-area"></div>
            </div>
          </div>
        </div>
        <textarea id="image_name" name="image_name" style="display:none;"></textarea>
        <div class="form-group">
          <button type="button" onClick="preview_snapshot()" class="preview_snapshot btn btn-success"><i class="fa fa-play-circle-o"></i> {{Trans("users.take_snapshot")}}</button>
          <button type="button" onClick="start_webcam()" class="start_webcam btn btn-default"><i class="fa fa-camera"></i> {{Trans("users.start_webcam")}}</button>
          <button type="button" onClick="closeWebCam()" class="cancel_preview btn btn-danger"><i class="fa fa-stop"></i> Stop</button>
        </div>
    </div>
</div>
