@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('customers.menu') }}
      <small>{{ Trans('dashboard.crud.edit') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ Route('customers.index')}}"><i class="fa fa-user-plus"></i> {{ Trans('customers.menu')}}</a></li>
      <li class="active"><a href="#">{{ Trans('dashboard.crud.edit') }}</a></li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    @include('layouts.includes.message')
    {{ Form::model($customer,[ 'route' => ['customers.update', $customer->id], 'method' => 'patch', 'files' => true]) }}
    @include('Customers.inc.formv2')
    {{ Form::close() }}
  </section>
@endsection
@section('addJs')
    {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
    {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
    {{ HTML::script('production/js/webcam.js') }}
@endsection
