@extends('layouts.production')
@section('addCss')
    <style media="screen">
        fieldset {
            border: 1px solid #ddd !important;
            padding: 10px;
            margin-bottom: 20px;
        }
        legend { font-size: 14px; border-bottom: 0; width: inherit; border: 1px solid #ddd; padding: 5px; margin-bottom: 0;}
       .sweet-alert fieldset {
           border: 0 !important; 
           padding: 0 !important; 
           margin-bottom: 0 !important; 
      }
      .spinner {
        position: absolute;
        z-index: 1000;
        top: 45%;
        left: 45%;
      }
    </style>
@endsection
@section('content')
<section class="content-header">
    <h1>
        {{ Trans('customers.menu') }}
        <small>{{ Trans('customers.show') }}</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
        <li><a href="{{ Route('customers.index') }}"><i class="fa fa-user-plus"></i> {{ Trans('customers.menu') }}</a></li>
        <li class="active">{{ $loanCustomer->full_name_kh }}</li>
    </ol>
</section>
<!-- Main content -->
<section class="content"> 
    <div class="spinner">
        <i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i>
        <span class="sr-only">Loading...</span>
    </div>
    @include('layouts.includes.message')
    @include('loan_customers.inc.modal_installment')
<div class="row">
    <div class="col-md-12">
        <div class="box">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs" id="customerTab" data-id="{{$loanCustomer->id}}">
                    <li class="active"><a href="#customer" data-toggle="tab" data-url="{{ route('loanCustomers.getCustomer', $loanCustomer->id) }}"><strong><i class="fa fa-user-plus"></i> {{ trans('installments.customer_info') }}</strong></a></li>
                    <li><a href="#company" data-toggle="tab" data-url="{{ route('loanCustomers.getCompany', $loanCustomer->id) }}"><strong><i class="fa fa-building-o"></i> {{ trans('installments.company_info') }}</strong></a></li>
                    <li><a href="#garantor" data-toggle="tab" data-url="{{ route('loanCustomers.getGarantor', $loanCustomer->id) }}"><strong><i class="fa fa-user"></i> {{ trans('installments.waranty_info') }}</strong></a></li>
                    <li><a href="#product" data-toggle="tab" data-url="{{ route('loanCustomers.getInstallment', $loanCustomer->id) }}"><strong><i class="fa fa-mobile fa-1x"></i> {{ trans('installments.menu') }}</strong></a></li>
                    <!--<li><a href="#emi-loan" data-toggle="tab" data-url="{{ route('loanCustomers.getEMILoan', $loanCustomer->id) }}"><strong><i class="fa fa-calculator fa-1x"></i> EMI</strong></a></li> -->
                </ul>
            <div class="tab-content">
                <div class="tab-pane fade in active" id="customer">
                </div>
                <!-- /.tab-pane -->
                <div class="tab-pane fade" id="company">
                </div>
                <!-- /.tab-pane -->
                <div class="tab-pane fade" id="garantor">
                </div>
                <!-- /.tab-pane -->
                <!-- /.tab-pane -->
                <div class="tab-pane fade" id="product">
                </div>
                <!--<div class="tab-pane fade" id="emi-loan">
                </div>-->
            <!-- /.tab-pane -->
            </div>
            <!-- /.tab-content -->
            </div>
            <!-- nav-tabs-custom -->
        </div>
    </div>
</div>
</section>
@endsection
@section('addJs')
{{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
{{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
{{ HTML::script('production/js/webcam.js') }}
{{ HTML::script('js/loadCustomer.js') }}
<script>
  $(function () {
   $(".spinner").hide();
   loanCustomer.init();
  });
</script>
@endsection
