<table id="example1" class="table table-bordered table-striped">
  <thead>
    <tr>
      <th>#</th>
      <th>{{ Trans('products.categories.name') }}</th>
      @if(UserRole::has('edit_category') || UserRole::has('delete_category'))
      <th>{{ Trans('dashboard.crud.actions') }}</th>
      @endif
    </tr>
  </thead>
  <tbody>
    @foreach($categories as $category)
      <tr>
        <td>{{ $category->id }}</td>
        <td>{{ $category->name }}</td>
        @if(UserRole::has('edit_category') || UserRole::has('delete_category'))
        <td>
          @if(UserRole::has('edit_category'))
          <a href="{{ Route("categories.edit",$category->id) }}" class="btn btn-xs btn-info">{{Trans("dashboard.crud.edit")}}</a>
          @endif
          @if(UserRole::has('delete_category'))
          <a href="#" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#myModal{{$category->id}}">{{Trans("dashboard.crud.remove")}}</a>
          @include('layouts.includes.modals.danger', ['model' => $category,'toRoute'=>'categories','attribute'=>'name'])
          @endif
        </td>
        @endif
      </tr>
    @endforeach
  </table>
