@extends('layouts.production')
@section('addCss')
<style media="screen">
  #example1_filter input[type=search] {
    width: 200px;
  }
</style>
@endsection
@section('content')
  <section class="content-header">
    <h1>
      {{Trans("products.product_category")}}
      <small>{{Trans("dashboard.crud.add")}} {{Trans("dashboard.crud.new")}}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ Route('categories.create')}}"><i class="fa fa-tag"></i> {{ Trans('products.categories.menu')}}</a></li>
      <li class="active">{{Trans("dashboard.crud.add")}}</li>
    </ol>
  </section>

  <!-- Main content -->

  <section class="content">
    @include('layouts.includes.message')
    <div class="row">
      <div class="col-md-4">
        <div class="box">
          <div class="box-body">
            {{ Form::open(['files' => true]) }}
            <div class="form-group">
              {{ Form::label('name', Trans('products.categories.name')) }}
              {{ Form::text('name', null, [
                'class' => 'form-control',
                'placeholder' => Trans('products.categories.name'),
                'required' => "required"
              ])}}
            </div>
            <div class="form-group">
              {{ Form::label('icon', Trans('products.categories.icon')) }}
              {{ Form::file('icon', [
                  'class' => 'form-control',
                  'placeholder' => Trans('products.categories.icon')
              ])}}
            </div>
            <div class="form-group">
              {{ Form::label('comment', Trans('products.categories.comment')) }}
              {{ Form::textarea('comment', null, [
                  'class' => "form-control",
                  'placeholder' => Trans('products.categories.comment'),
                  'rows' => '3'
              ])}}
            </div>
            <div class="form-group pull-right">
              <button type="submit" name="submit" class="btn btn-info form-group">{{ Trans('dashboard.crud.add')}}</button>
            </div>
            {{ Form::close() }}
          </div>
        </div>
      </div>
      <div class="col-md-8">
        @if(UserRole::has('list_category'))
        <div class="box">
          <div class="box-body">
            @include('categories.table')
          </div>
        </div>
        @endif
          <!-- /.box -->
      </div>
    </div>
  </section>
@endsection
@section('addJs')
<script>
  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": true,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>
@endsection
