@extends('layouts.production')
@section('addCss')
  <style media="screen">
    #brand-data tr td {
      vertical-align: middle;
    }
  </style>
@endsection
@section('content')
  <section class="content-header">
    <h1>
      {{Trans("brands.menu")}}
      <small>{{Trans("dashboard.crud.add")}} {{Trans("dashboard.crud.new")}}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="#" class="active"><i class="fa fa-mobile "></i> {{ trans('brands.menu')}}</a></li>
    </ol>
  </section>

  <!-- Main content -->

  <section class="content">
    @include('layouts.includes.message')
    <div class="row">
      <div class="col-md-4">
        <div class="box box-info">
          <div class="box-header with-border">
            <h3 class="box-title">{{ $brand->exists ? trans('brands.edit_form') : trans('brands.create_form') }}
            </h3>
          </div>
            <div class="box-body">
              {{ Form::model($brand,
                [
                  'method' => $brand->exists ?  "PUT" : "POST",
                  'route'  => $brand->exists ? ["brands.update", $brand->id] : "brands.store",
                  'files'  => true
              ]) }}
              <div class="row">
                <div class="col-md-12">
                  <div class="form-group">
                      {{ Form::label('name', trans('brands.name')) }}
                      {{ Form::text('name', null, ['class' => 'form-control', 'required' => 'required', 'placeholder' => trans('brands.name') ]) }}
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-md-12">
                  <div class="form-group">
                      {{ Form::label('logo', trans('brands.logo')) }}
                      {{ Form::file('logo', ['class' => "form-control" ]) }}
                  </div>
                </div>
              </div>
            </div>
            <div class="box-footer">
              <div class="pull-right">
                <button type="submit" class="btn btn-primary">{{ $brand->exists ? trans('dashboard.crud.update') : trans('dashboard.crud.add') }} </button>
                <button type="reset" class="btn btn-default">{{ trans('dashboard.crud.reset') }}</button>
              </div>
              {{ Form::close() }}
            </div>
        </div>
      </div>
      <div class="col-md-8">
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">{{ trans('dashboard.others.show_all') }}</h3>
          </div>
            <div class="box-body">
              <table class="table table-bordered" id="brand-data">
                <thead>
                  <tr>
                    <th style="width:10%">{{ trans('brands.id') }}</th>
                    <th style="width:20%">{{ trans('brands.logo') }}</th>
                    <th>{{ trans('brands.name')}}</th>
                    <th style="width:20%">{{ trans('dashboard.crud.actions') }}</th>
                  </tr>
                </thead>
                <tbody>
                @if (count($brands) > 0)
                  @foreach ($brands as $brand)
                  <tr>
                    <td>{{ $brand->id }}</td>
                    <td>{{ HTML::image($brand->logo, $brand->name, ['class' => 'img-thumbnail', 'width' => "35%"]) }}</td>
                    <td>{{ $brand->name }} <span class="badge badge-info">{{ count_product_in_brand($brand->id)}}</span></td>
                    <td>
                      <a href="{{ route('brands.edit', $brand->id) }}" class="btn btn-xs btn-info"><i class="fa fa-edit"></i>  {{ trans('dashboard.crud.edit') }}</a>
                      <a href="#" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#myModal{{$brand->id}}"><i class="fa fa-trash"></i> {{Trans("dashboard.crud.remove")}}</a>
                      @include('layouts.includes.modals.danger', ['model' => $brand,'toRoute'=>'brands','attribute'=>'name'])
                    </td>
                  </tr>
                @endforeach
                @endif
                </tbody>
              </table>
        </div>
      </div>
    </div>
  </section>
@endsection
@section('addJs')
  <script type="text/javascript">
  $(function () {
    $('#brand-data').DataTable();
  });
  </script>
@endsection
