@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('dashboard.branches.branch') }}
        <small>{{ Trans('suppliers.show') }}</small>
    </h1>

    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li>{{ Trans('dashboard.branches.branch') }}</li>
      <li class="active">{{ Trans('dashboard.others.show_all') }}</li>
    </ol>
  </section>
  <!-- Main content -->
  <section class="content">
    @include('layouts.includes.message')
    <div class="box box-body">
      <table class="table table-bordered" id="example1">
        <thead>
          <tr>
            <th>#</th>
            <th>{{ Trans('dashboard.branches.branch')}}</th>
            <th>{{ Trans('users.tel')}}</th>
            <th>{{ Trans('dashboard.branches.latitude')." ".Trans('dashboard.branches.longtitude')}}</th>
            @if(UserRole::has('edit_branch') || UserRole::has('delete_branch'))
            <th>{{ Trans('dashboard.crud.actions')}}</th>
            @endif
          </tr>
        </thead>
        <tbody>
        @if(isset($branches))
          @foreach($branches as $branch)
            @include('branches.inc.branch_row')
          @endforeach
        @elseif(isset($branch))
            @include('branches.inc.branch_row')
        @endif
        </tbody>
      </table>
    </div>
  </section>
@endsection
@section('addJs')
  <script>
  $(function () {
    $("#example1").DataTable();
  });
  </script>
@endsection
