@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('dashboard.branches.branch')}}
      <small>{{Trans("dashboard.crud.edit")}}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ route('branches.index')}}">{{ Trans('dashboard.branches.branch') }}</a></li>
      <li class="active">{{ Trans('dashboard.others.show_all') }}</li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    @include('layouts.includes.message')
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">{{Trans("dashboard.crud.edit")}}</h3>
      </div>
      <div class="box-body">
        {{ Form::model($branch,['method'=>'patch','route'=>['branches.update',$branch->id],'files'=>true]) }}
  	      @include('branches.inc.form')
  	    {{ Form::close() }}
      </div>
    </div>

  </section>
@endsection
