<table class="table">
	<thead>
		<tr>
			<th>{{ trans('products.id') }}</th>
			<th>{{ trans('products.sku') }}</th>
			<th>{{ trans('products.name') }}</th>
			<th>{{ trans('products.amount') }}</th>
			<th>{{ trans('products.price_in') }}</th>
			<th>{{ trans('sale.total') }}</th>
			<th>{{ trans('dashboard.crud.actions') }}</th>
		</tr>
	</thead>
	<tbody>
		@if (count($products) > 0) 
		<?php 
			$i = 1;
			$totalPrice = 0;
		 ?>
			@foreach($products as $product)
			<?php $totalPrice += $product->qty * $product->price; ?>
				<tr>
					<td>{{ $i++}}</td>
					<td>{{ $product->sku }}</td>
					<td>{{ $product->name }}</td>
					<td><input type="number" id="qty-update-{{$product->id}}" value="{{ $product->qty }}" class="form-control" style="width:20%;"></td>
					<td>{{ money($product->price) }}</td>
					<td>{{ money($product->price * $product->qty) }}</td>
					<td>
						<button class="btn btn-info btn-sm btn-edit" data-buy-product-id="{{$product->id}}" data-invoice-id="{{ $invoiceId }}">{{ trans('dashboard.crud.edit') }}</button>
						<button class="btn btn-danger btn-sm btn-delete" data-buy-product-id="{{$product->id}}" data-invoice-id="{{ $invoiceId }}">{{ trans('dashboard.crud.remove') }}</button>
					</td>
				</tr>
			@endforeach
			<tr>
				<td colspan="6" class="text-right"><b>{{ trans('sale.total') }}</b></td>
				<td><b>{{ money($totalPrice) }}</b></td>
			</tr>
		@else
			<tr>
				<td colspan="8" class="text-center">{{ trans('backend_sale.no_product') }}</td>
			</tr>
		@endif
	</tbody>
</table>