<div class="modal fade" tabindex="-1" role="dialog" id="myModal">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">{{ trans('backend_sale.add_product') }}</h4>
      </div>
      <div class="modal-body">
        {{ Form::open(['method' => 'post', 'url' => "dashboard/sale", 'id' => 'form-product']) }}
            <div class="row">
              <div class="col-md-6">
                <div class="form-group{{ $errors->has('sku') ? ' has-error' : '' }}">
                    {{ Form::label('sku', trans('products.sku')) }}
                    {{ Form::text('sku', null, [
                        'class' => 'form-control', 
                        'required' => 'required',
                        'placeholder' => trans('products.sku')
                    ]) }}
                    <small class="text-danger">{{ $errors->first('sku') }}</small>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group{{ $errors->has('name') ? ' has-error' : '' }}">
                    {{ Form::label('name', trans('products.name')) }}
                    {{ Form::text('name', null, [
                      'class' => 'form-control', 
                      'required' => 'required',
                      'placeholder' => trans('products.name')
                    ]) }}
                    <small class="text-danger">{{ $errors->first('name') }}</small>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group{{ $errors->has('amount') ? ' has-error' : '' }}">
                    {{ Form::label('amount', trans('products.amount')) }}
                    {{ Form::text('amount', null, [
                      'class' => 'form-control', 
                      'required' => 'required',
                      'placeholder' => trans('products.amount')
                    ]) }}
                    <small class="text-danger">{{ $errors->first('amount') }}</small>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group{{ $errors->has('price') ? ' has-error' : '' }}">
                    {{ Form::label('price', trans('products.price_in')) }}
                    {{ Form::text('price', null, [
                      'class' => 'form-control', 
                      'required' => 'required',
                      'placeholder' => trans('products.price_in')
                    ]) }}
                    <small class="text-danger">{{ $errors->first('price') }}</small>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-12">
                <div class="form-group{{ $errors->has('comment') ? ' has-error' : '' }}">
                    {{ Form::label('comment', trans('products.comment')) }}
                    {{ Form::textarea('comment', null, [
                        'class' => 'form-control', 
                        'rows' => '3',
                        'placeholder' => trans('products.comment')
                    ]) }} 
                    <small class="text-danger">{{ $errors->first('comment') }}</small>
                </div>
              </div>
            </div>
        </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">{{ trans('dashboard.crud.cancel') }}</button>
        <button type="submit" class="btn btn-primary pull-right">{{ trans('dashboard.crud.add') }}</button>
        {{ Form::close() }}
      </div>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->