@extends('layouts.production')
@section('addCss')
<style media="screen">
  #example2_filter input[type=search] {
    width: 200px;
  }
  table tr td {
    vertical-align: middle !important;
  }
</style>
@endsection
@section('content')
  <section class="content-header">
    <h1 id="invoice" data-invoice-id="{{ $invoice->id }}" data-get-table-url="{{ route('buy.table')}}" data-edit-url="{{ route('buy.edit')}}" data-delete-url="{{ route('buy.delete') }}">
      {{ Trans("dashboard.sale")}}
      <small>{{ Trans("dashboard.crud.add")}}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active">{{ Trans("dashboard.sale")}}</li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    @include('layouts.includes.message')
    @include('backend_sale.modal')
    <div class="row">
      <div class="col-md-6">
         <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title" style="width:100%;">{{ trans('backend_sale.old_product') }} <a type="button" class="btn btn-primary btn-sm pull-right" data-toggle="modal" data-target="#myModal"><i class="fa fa-plus"></i>​ {{ trans('backend_sale.add_new') }}</a></h3> 
          </div>
          <div class="box-body">
            <table class="table" id="product-second-hand">
              <thead>
                <tr>
                  <th>{{ trans('products.sku') }}</th>
                  <th>{{ trans('products.name') }}</th>
                  <th>{{ trans('products.price_in') }}</th>
                  <th>{{ trans('dashboard.crud.actions') }}</th>
                </tr>
              </thead>
              <tbody>
                
              </tbody>
            </table>
          </div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">{{ trans('backend_sale.exist_old_product') }}</h3>
          </div>
          <div class="box-body">
            <table class="table">
              <thead>
                <tr>
                  <th>{{ trans('products.sku') }}</th>
                  <th>{{ trans('products.name') }}</th>
                  <th>{{ trans('products.amount') }}</th>
                  <th>{{ trans('products.price') }}</th>
                </tr>
              </thead>
              <tbody>
              @if (count($products) > 0)
                @foreach($products as $product)
                  <tr>
                    <td>{{ $product->sku }}</td>
                    <td>{{ $product->name }}</td>
                    <td>{{ $product->amount }}</td>
                    <td>{{ money($product->price) }}</td>
                  </tr>
                @endforeach
                <tr>
                  <td colspan="3" class="text-right"><b>{{ trans("sale.total") }}</b></td>
                  <td><b>{{ money($invoice->total) }}</b></td>
                </tr>
              @else 
                <tr>
                  <td colspan="8" colspan="text-center">{{ trans('backend_sale.no_product')}}</td>
                </tr>
              @endif
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12">
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">{{ trans('backend_sale.buy_p') }}</h3>
          </div>
          <div class="box-body">
            <div id="buy-products"></div>
          </div>
        </div>
      </div>
    </div>
   
  </section>
@endsection
@section('addJs')
  {{ HTML::script('js/buy_product.js') }}
  <script>
    // jQuery plugin to prevent double submission of forms
    jQuery.fn.preventDoubleSubmission = function() {
      $(this).on('submit',function(e){
        var $form = $(this);

        if ($form.data('submitted') === true) {
          // Previously submitted - don't submit again
          e.preventDefault();
        } else {
          // Mark it so that the next submit can be ignored
          $form.data('submitted', true);
        }
      });

      // Keep chainability
      return this;
    };
    $(function() {
      bp.getTable();
      bp.addProduct();
      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $("#product-second-hand").DataTable({
        "ajax"        : "{{Route('get.products')}}",
        "processing"  : true,
        "serverSide"  : true,
        "pageLength"  : 5,
        "paging": true,
        "autoWidth": false,
        "columnDefs": [
          { "targets": 0, "orderable": false},
          { "searchable": false, "targets": 3 },
        ],
        "columns": [
            {data: 'sku', name: 'products.sku',title: '{{ Trans('products.sku') }}'},
            {data: 'name', name: 'products.name',orderable: false,title: '{{ Trans('products.name') }}'},
            {data: 'price_in', name: 'products.price_in',orderable: false,title: '{{ Trans('products.price_in') }}'},
            {data: 'action', name: 'action',orderable: false,title: '{{ Trans('dashboard.crud.actions') }}'},

        ],
        fnDrawCallback : function() {
          bp.selectProduct();
        },
        initComplete: function () {
          this.api().columns([1,2,3]).every(function () {
              var column = this;
              var input = document.createElement("input");
              $(input).appendTo($(column.footer()).empty())
              .on('change', function () {
                  var val = $.fn.dataTable.util.escapeRegex($(this).val());
                  column.search(val ? val : '', true, false).draw();
              });
          });
          // Call btn Select
         // bp.selectProduct();

        }
        
        });
    });
  </script>
@endsection
