<table class="table table-bordered table-hover"​ id="example2">
  <thead>
    <tr>
      <th>#</th>
      <th>{{ Trans('products.unit')}}</th>
      @if(UserRole::has('edit_unit') || UserRole::has('delete_unit'))
      <th>{{ Trans('dashboard.crud.actions')}}</th>
      @endif
    </tr>
  </thead>
  <tbody>
    @foreach($units as $unit)
      <tr>
        <td>{{ $unit->id }}</td>
        <td>{{ $unit->name }}</td>
        @if(UserRole::has('edit_unit') || UserRole::has('delete_unit'))
        <td>
          @if(UserRole::has('edit_unit'))
          <a href="{{ Route("units.edit",$unit->id) }}" class="btn btn-xs btn-info">{{Trans("dashboard.crud.edit")}}</a>
          @endif
          @if(UserRole::has('delete_unit'))
          <a href="#" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#myModal{{$unit->id}}">{{Trans("dashboard.crud.remove")}}</a>
          @include('layouts.includes.modals.danger', ['model' => $unit,'toRoute'=>'units','attribute'=>'name'])
          @endif
        </td>
        @endif
      </tr>
    @endforeach
  </tbody>
</table>
