@extends('layouts.production')
@section('addCss')
<style media="screen">
  #example2_filter input[type=search] {
    width: 200px;
  }
</style>
@endsection
@section('content')
  <section class="content-header">
    <h1>
      {{Trans("units.menu")}}
      <small>{{Trans("dashboard.crud.edit")}}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ Route('units.index') }}"><i class="fa fa-tags"></i> {{ Trans('units.menu')}}</a></li>
      <li class="active">{{Trans("dashboard.crud.edit")}}</li>
    </ol>
  </section>

  <!-- Main content -->

  <section class="content">
    @include('layouts.includes.message')
    <div class="row">
      <div class="col-md-4">
        <div class="box box-body">
          <div class="form-group">
            {{ Form::model($unit, array('route' => ['units.update', $unit->id], 'method' => 'patch')) }}
            {{ Form::label('name', Trans('units.name')) }}
            {{ Form::text('name', null, [
              'class' => 'form-control',
              'placeholder' => Trans('units.name'),
              'required'  => 'required'
            ])}}
          </div>
          <div class="form-group pull-right">
            <button type="submit" name="submit" class="btn btn-info">{{ Trans('dashboard.crud.update') }}</button>
          </div>
          {{ Form::close() }}
        </div>

      </div>
      <div class="col-md-8">
        <div class="box box-body">
          @include('Units.table')
        </div>
      </div>
    </div>
  </section>
@endsection
@section('addJs')
<script>
  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": true,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>
@endsection
