@extends('layouts.production')
@section('addCss')
<style media="screen">
  #example2_filter input[type=search] {
    width: 200px;
  }
</style>
@endsection
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans("roles.roles")}}
      <small>{{ Trans("dashboard.others.show_all")}}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active">{{ Trans("roles.roles")}}</li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    @include('layouts.includes.message')
    <div class="box">
      <div class="box-body">
        <table class="table table-bordered" id="example1">
          <thead>
            <tr>
              <th>#</th>
              <th>{{Trans("roles.role_name")}}</th>
              @if(UserRole::has('edit_role') || UserRole::has('delete_role'))
              <th>{{Trans("dashboard.crud.actions")}}</th>
              @endif
            </tr>
          </thead>
          <tbody>
            @foreach($roles as $role)
              <tr>
                <td>{{ $role->id }}</td>
                <td>{{ $role->role_name }}</td>
                @if(UserRole::has('edit_role') || UserRole::has('delete_role'))
                <td>
                  @if(UserRole::has("edit_role"))
                    <a href="{{ Route("roles.edit",$role->id) }}" class="btn btn-xs btn-info">{{Trans("dashboard.crud.edit")}}</a>
                  @endif
                  @if(UserRole::has("delete_role"))
                    <a href="#" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#myModal{{$role->id}}">{{Trans("dashboard.crud.remove")}}</a>
                  @endif
                  @include('layouts.includes.modals.danger', ['model' => $role,'toRoute'=>'roles','attribute'=>'role_name'])
                </td>
                @endif
              </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </section>
@endsection
@section('addJs')
<script>
  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": true,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>
@endsection
