@extends('layouts.production')
@section('addCss')
@endsection
@section('content')
	<?php
		$upermissions = UserRole::getPermissionByRole($role->id);
		// debug(UserRole::has($role->id,'create_user'));
	?>
  <section class="content-header">
    <h1>
      {{ Trans('roles.roles') }}
      <small>{{Trans('roles.role_name')}}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ route('roles.index')}}"><i class="fa fa-dashboard"></i> {{ trans('roles.roles')}}</a></li>
      <li class="active">{{ trans('dashboard.crud.edit')}}</li>
    </ol>
  </section>
  <!-- Main content -->
  <section class="content">
		@include('layouts.includes.message')
    <div class="row">
		{{ Form::model($role,['method'=>'patch','route'=>['roles.update',$role->id]]) }}
    	<div class="col-md-4">
	    	<div class="box">
	    	  <div class="box-body">
            <div class="form-group">
    	        {{ Form::label('role_name', Trans('roles.role_name')) }}
    	        {{ Form::text('role_name', null, [
    	            'class' => 'form-control',
    	            "required"=>"required",
    	            'placeholder' => Trans('roles.role_name')
    	        ])}}
    	      </div>
    	      <div class="form-group">
    	        {{ Form::label('description', Trans('products.comment')) }}
    	        {{ Form::textarea('description', null, [
    	            'class' => 'form-control',
    	            'placeholder' => Trans('products.comment'),
    	            'rows'  => '3'
    	        ])}}
    	      </div>
            <div class="form-group">
              <button type="submit" name="submit" class="btn btn-info">{{ Trans('dashboard.crud.update') }}</button>
              <button type="reset" name="reset" class="btn btn-default">{{ Trans('buttons.reset') }}</button>
            </div>
	    	  </div>
	    	</div>
      </div>
    	<div class="col-md-8">
        <div class="panel-group" id="accordion">
          <?php $i =0; ?>
          @foreach($groups as $key => $value)
            <div class="panel panel-default">
              <div class="panel-heading">
                <h4 class="panel-title">
                  <a data-toggle="collapse" data-parent="#accordion" href="#collapse{{$key}}">
                  @if ($key == "customer")
                    <i class="fa fa-user-plus"></i>
                  @elseif ($key == "income_expense_debt")
                    <i class="fa fa-usd"></i>
                  @elseif ($key == "invoice")
                    <i class="fa fa-money"></i>
                  @elseif ($key == "location")
                    <i class="fa fa-map"></i>
                  @elseif ($key == "product")
                    <i class="fa fa-product-hunt"></i>
                  @elseif ($key == "quotation")
                    <i class="fa fa-file-text-o"></i>
                  @elseif ($key == "supplier")
                    <i class="fa fa-building-o"></i>
                  @elseif ($key == "service")
                    <i class="fa fa-wrench"></i>
                  @elseif ($key == "setting")
                    <i class="fa fa-cog"></i>
                  @elseif ($key == "user_position_role")
                    <i class="fa fa-users"></i>
                  @elseif ($key == "report")
                    <i class="fa fa-filter"></i>
                  @endif
                  {{ trans('roles.'. $key) }}</a>
                </h4>
              </div>
              <div id="collapse{{$key}}" class="panel-collapse collapse @if($i == 0) in @else out @endif">
                <div class="panel-body">
                @foreach($value as $g)
                  <div class="form-group col-md-3">
      	            <div class="checkbox">
      	              <label>
      	                <input type="checkbox" name="perm[]" value="{{$g['id']}}" @if(in_array($g['id'], $upermissions)) checked @endif> {{ $g['name'] }}
      	              </label>
      	            </div>
      	          </div>
                @endforeach
                </div>
              </div>
            </div>
            <?php $i++; ?>
          @endforeach
        </div>
      </div>
      {{ Form::close() }}
    </div>
  </section>
@endsection
