@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('roles.roles') }}
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ route('roles.index')}}"><i class="fa fa-dashboard"></i> {{ trans('roles.roles')}}</a></li>
      <li class="active">{{ trans('dashboard.crud.add')}}</li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
  @include('layouts.includes.message')
    <div class="row">
    {{ Form::open(array('route' => 'roles.store','method'=>'POST')) }}
    	<div class="col-md-4">
	    	<div class="box">
	    	  <div class="box-body">
            <div class="form-group">
    	        {{ Form::label('role_name', Trans('roles.role_name')) }}
    	        {{ Form::text('role_name', null, [
    	            'class' => 'form-control',
    	            "required"=>"required",
    	            'placeholder' => Trans('roles.role_name')
    	        ])}}
    	      </div>
    	      <div class="form-group">
    	        {{ Form::label('description', Trans('products.comment')) }}
    	        {{ Form::textarea('description', null, [
    	            'class' => 'form-control',
    	            'placeholder' => Trans('products.comment'),
    	            'rows'  => '3'
    	        ])}}
    	      </div>
            <div class="form-group">
              <button type="submit" name="submit" class="btn btn-info">{{ Trans('dashboard.crud.add') }}</button>
              <button type="reset" name="reset" class="btn btn-default">{{ Trans('buttons.reset') }}</button>
            </div>
	    	  </div>
	    	</div>
      </div>
    	<div class="col-md-8">
        <div class="panel-group" id="accordion">
          <?php $i =0;
          $checked = (Input::get('perm[]') ? true : false);
          ?>
          @foreach($groups as $key => $value)
            <div class="panel panel-default">
              <div class="panel-heading">
                <h4 class="panel-title">
                  <a data-toggle="collapse" data-parent="#accordion" href="#collapse{{$key}}">
                  {{ trans('roles.'. $key) }}</a>
                </h4>
              </div>
              <div id="collapse{{$key}}" class="panel-collapse collapse @if($i == 0) in @else out @endif">
                <div class="panel-body">
                @foreach($value as $g)
                  <div class="form-group col-md-3">
      	            <div class="checkbox">
      	              <label>
                        {{ Form::checkbox('perm[]', $g['id'], Input::old('perm[]', $checked)) }} {{ $g['name'] }}
      	              </label>
      	            </div>
      	          </div>
                @endforeach
                </div>
              </div>
            </div>
            <?php $i++; ?>
          @endforeach
        </div>
      </div>
    {{ Form::close() }}
    </div>
  </section>
@endsection
