@extends('layouts.production')
@section('addCss')
{{ HTML::style('plugins/datatables/dataTables.bootstrap.css') }}
<style media="screen">
  #example2_filter input[type=search] {
    width: 200px;
  }
</style>
@endsection
@section('content')
  <section class="content-header">
    <h1>
      {{Trans("profits.menu")}}
      <small>{{Trans("dashboard.crud.edit")}} </small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ Route('profits.index') }}"><i class="fa fa-usd"></i> {{ Trans('profits.menu')}}</a></li>
      <li class="active">{{Trans("dashboard.crud.edit")}}</li>
    </ol>
  </section>

  <!-- Main content -->

  <section class="content">
    @include('layouts.includes.message')
    <div class="row">
    @include('Profits.content')
    </div>

  </section>
@endsection
@section('addJs')
{{ HTML::script("plugins/datatables/jquery.dataTables.min.js") }}
{{ HTML::script('plugins/datatables/dataTables.bootstrap.min.js') }}
<script>
    $(function () {
      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
      $("#example2").DataTable({
        "ajax"        : "{{Route('getProfits')}}",
        "processing"  : true,
        "serverSide"  : true,
        "paging": true,
        "autoWidth": false,
        "columnDefs": [
          { "searchable": false, "targets": 7 }
        ],
        "columns": [
            {data: 'id', name: 'Profits.id',title: 'Id'},
            {data: 'amount', name: 'Profits.amount',orderable: false,title: '{{ Trans('profits.amount')}}'},
            {data: 'type', name: 'Profits.type',orderable: false,title: '{{ Trans('profits.type')}}'},
            {data: 'description', name: 'Profits.description',orderable: false,title: '{{ Trans('profits.description') }}'},
            {data: 'invoice_id', name: 'Profits.invoice_id',orderable: false,title: '{{ Trans('invoices.menu') }}'},
            {data: 'userName', name: 'Users.first_name',orderable: false,title: '{{ Trans('products.by') }}'},
            {data: 'created_at', name: 'Profits.created_at',orderable: false,title: '{{ Trans('profits.created_at') }}'},
            {data: 'action', name: 'action',orderable: false,title: '{{ Trans('dashboard.crud.actions') }}'},

        ],
        initComplete: function () {
          this.api().columns([1,2,3]).every(function () {
              var column = this;
              var input = document.createElement("input");
              $(input).appendTo($(column.footer()).empty())
              .on('change', function () {
                  var val = $.fn.dataTable.util.escapeRegex($(this).val());
                  column.search(val ? val : '', true, false).draw();
              });
          });
        }
      });
    });
  </script>
@endsection
