<div class="col-md-4">
  <div class="box box-body">
    @if(isset($profit->id))
    {{ Form::model($profit, array('method' => 'patch', 'route' => ['profits.update', $profit->id])) }}
    @else
    {{ Form::open(array('route' => 'profits.store')) }}
    @endif
    <div class="form-group">
      {{ Form::label('amount', Trans('profits.amount')) }}
      {{ Form::number('amount', null, [
        'class' => 'form-control',
        'placeholder' => Trans('profits.amount'),
        'required'  => 'required',
        'step'  => "any",
      ])}}
    </div>
    <div class="form-group">
      {{ Form::label('type', Trans('profits.type')) }}
      <?php
        if(App::getLocale() == "kh") {
          $type = [
            'income' => trans('profits.income'),
            'expense' => trans('profits.expense')
          ];
        }
        else {
          $type = [
            'income' => "Income",
            'expense' => "Expense"
          ];
        }
        $selected = isset($profit->type) ? $profit->type : "";
      ?>

      {{ Form::select('type',$type, $selected, ['class' => 'form-control']) }}
    </div>
    <div class="form-group">
      {{ Form::label('description', Trans('profits.description')) }}
      {{ Form::textarea('description', null, [
        'class' => 'form-control',
        'placeholder' => Trans('profits.description'),
        'rows' => '3'
      ])}}
    </div>

    <div class="form-group pull-right">
      <button type="submit" name="submit" class="btn btn-info">
        @if(isset($profit->id))
          {{ Trans('dashboard.crud.update') }}
        @else
          {{ Trans('buttons.add') }}
        @endif
      </button>
    </div>
    {{ Form::close() }}
  </div>

</div>
<div class="col-md-8">
  <div class="box box-body">
    <table class="table table-bordered table-hover" id="example2">
    </table>

  </div>
</div>
