<table id="example1" class="table table-striped table-bordered">
  <thead>
    <tr>
      <th>#</th>
      <th>{{ Trans('positions.menu')}}</th>
      <th>{{ Trans('positions.for')}}</th>
      @if(UserRole::has('edit_position') || UserRole::has('delete_position'))
      <th>{{ Trans('dashboard.crud.actions')}}</th>
      @endif
    </tr>
  </thead>
  <tbody>
    @foreach($positions as $position)
      <tr>
        <td>{{ $position->id }}</td>
        <td>{{ $position->name }}</td>
        <td>
          @if(App::getLocale() == "kh")
            {{ getPositionKh($position->for)}}
          @else
            {{ $position->for }}
          @endif
        </td>
        @if(UserRole::has('edit_position') || UserRole::has('delete_position'))
        <td>
          @if(UserRole::has('edit_position'))
          <a href="{{ Route("positions.edit",$position->id) }}" class="btn btn-xs btn-info">{{Trans("dashboard.crud.edit")}}</a>
          @endif
          @if(UserRole::has('delete_position'))
          <a href="#" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#myModal{{$position->id}}">{{Trans("dashboard.crud.remove")}}</a>
          @include('layouts.includes.modals.danger', ['model' => $position,'toRoute'=>'positions','attribute'=>'name'])
          @endif
        </td>
        @endif
      </tr>
    @endforeach
  </tbody>
</table>
