@extends('layouts.production')
@section('addCss')
<style media="screen">
  #example1_filter input[type=search] {
    width: 200px;
  }
</style>
@endsection
@section('content')
  <section class="content-header">
    <h1>
      {{Trans("positions.menu")}}
      <small>{{Trans("dashboard.crud.edit")}}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ Route('positions.index') }}"><i class="fa fa-user"></i> {{ Trans('positions.menu')}}</a></li>
      <li class="active">{{Trans("dashboard.crud.edit")}}</li>
    </ol>
  </section>

  <!-- Main content -->

  <section class="content">
    @include('layouts.includes.message')

    <div class="row">
      <div class="col-md-4">
        <div class="box box-body">
          {{ Form::model($position, array('route' => ['positions.update', $position->id],'method'=>'patch')) }}
          <div class="form-group">
            {{ Form::label('name', Trans('positions.name')) }}
            {{ Form::text('name', null, [
              'class' => 'form-control',
              'placeholder' => Trans('positions.name'),
              'required'  => 'required'
            ])}}
          </div>
          <div class="form-group">
            {{ Form::label('for', Trans('positions.for')) }}
            <?php
              if(App::getLocale() == "kh") {
                $pos = [
                  'staff' => "បុគ្គលិក",
                  'supplier' => "តំណងចែកចាយ"
                ];
              }
              else {
                $pos = [
                  'staff' => "Staff",
                  'supplier' => "Supplier"
                ];
              }
            ?>
            {{ Form::select('for',$pos, $position->for, ['class' => 'form-control']) }}
          </div>
          <div class="form-group pull-right">
            <button type="submit" name="submit" class="btn btn-info">{{ Trans('dashboard.crud.update') }}</button>
          </div>
          {{ Form::close() }}
        </div>
    </div>
    <div class="col-md-8">
      <div class="box box-body">
        @include('Positions.table')
      </div>
    </div>
  </section>
@endsection
@section('addJs')
<script>
  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>
@endsection
