@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ str_limit(getField('Product','id',$outlet->product_id,'name'),20) }}
      <small>{{ str_limit(getField('Product','id',$outlet->product_id,'name_kh'),30) }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ Route('productIndex')}}"><i class="fa fa-dashboard"></i> Products</a></li>
      <li class="active">{{ getField('Product','id',$outlet->product_id,'name_kh') }}</li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    @include('layouts.includes.message')
    <div class="row">
      <div class="col-md-7">
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">{{ Trans('products.product_detail')}}</h3>
          </div>
          <div class="box-body">
            <div class="row">
              <div class="col-md-8">
                <table class="table table-striped table-bordered">
                  <tr>
                    <th>{{ Trans('products.sku') }}</th>
                    <td>{{ $outlet->sku }}</td>
                  </tr>
                  <tr>
                    <th>{{ Trans('products.price') }}</th>
                    <td>{{ money($outlet->price) }}</td>
                  </tr>
                  <tr>
                    <th>{{ Trans('stock.stock') }}</th>
                    <td>{{ $outlet->stock }}</td>
                  </tr>
                  <tr>
                    <th>{{ Trans('products.amount') }}</th>
                    <td>{{ $outlet->amount }}  {{ $outlet->unit }}</td>
                  </tr>
                  <tr>
                    <th>{{ Trans('stock.location') }}</th>
                    <td>{{ $outlet->location }}</td>
                  </tr>
                </table>
              </div>
              <div class="col-md-4">
                {{ HTML::image($outlet->thumbnail, $outlet->name, ['class' => 'img-responsive img-thumbnail'])}}
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="col-md-5">
        @if(Stock::getNumber() == "more")
          <!-- Horizontal Form -->
        <div class="box box-info">
            <div class="box-header with-border">
              <h3 class="box-title">{{ Trans('stock.transfer_product') }}</h3>
            </div>
            <!-- /.box-header -->
            <!-- form start -->
            @if(UserRole::has("transfer_to_stock"))
            {{ Form::open(array('route' => 'outlets.store','method'=>'POST', 'class'=>'form-horizontal')) }}
              <div class="box-body">
                <div class="form-group">
                  <input type="hidden" name="id" value="{{$outlet->outlet_id}}">
                  <input type="hidden" name="c_stock_id" value="{{$outlet->stock_id}}">
                  <label for="amount" class="col-sm-2 control-label">{{ Trans('products.amount')}}</label>
                  <div class="col-sm-10">
                    {{Form::number('amount',null,['id'=>'amount','class'=>'form-control','placeholder' => Trans('products.amount'),'required'=>'required'])}}
                  </div>
                </div>
                @if (!empty($stock) && $stock->type == "storage")
                <div class="form-group">
                  <label for="stock" class="col-sm-2 control-label">{{ Trans('stock.location')}}</label>

                  <div class="col-sm-10">
                    {{Form::text('location',stock_location($stock->id, $outlet->product_id),['id'=>'location','class'=>'form-control','placeholder' => Trans('stock.location'), 'required' => 'required'])}}
                  </div>
                </div>
                @endif
                <div class="form-group">
                  <label for="stock" class="col-sm-2 control-label">{{ Trans('stock.stock')}}</label>

                  <div class="col-sm-10">
                    {{Form::select('stock_id',$stocks,null,['class' => 'form-control select2'])}}
                  </div>
                </div>
              </div>
              <!-- /.box-body -->
              <div class="box-footer">
                <button type="submit" class="btn btn-info pull-right">{{ Trans('stock.transfer') }}</button>
              </div>
              <!-- /.box-footer -->
            </form>
            @endif
          </div>
          <!-- /.box -->
        @endif
      </div>
    </div>
    <div class="row">
      <div class="col-md-12">
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">{{ Trans('messages.captions.transaction_history')}}</h3>
          </div>
          <div class="box-body">
            <table id="example2" class="table table-bordered">
              <thead >
                <tr >
                  <th>#</th>
                  <th>{{Trans("products.name")}}</th>
                  <th>{{Trans("products.product_category")}}</th>
                  <th>{{Trans("products.amount")}}</th>
                  <th>{{Trans("products.by")}}</th>
                  <th>{{Trans("dashboard.crud.created_at")}}</th>
                  <th>{{Trans('products.operation_type') }}</th>
                  <th>{{Trans("stock.stock")}}</th>
                </tr>
              </thead>
              <tbody>
                @foreach($histories as $history)
                  <tr data-history="{{$history->id}}" data-url="{{Route('update_ref',$history->id)}}">
                    <td>{{ $history->id }}</td>
                    <td>{{ $history->pname }}</td>
                    <td>{{ getField("ProductCategory","id",getField('Product','id',$history->product_id,'product_category_id'),"name") }}</td>
                    <td>{{ $history->amount }}</td>
                    <td>{{ getField("User","id",$history->user_id,"first_name") }}</td>
                    <td>{{ $history->created_at }}</td>
                    <td>{{ Trans('products.'.$history->operation_type) }}</td>
                    <td>{{ getField("Stock","id",$history->stock_id,"name") }}</td>
                  </tr>
                @endforeach
                <tr>
                  <td colspan="9" class="text-right">Total Histories : {{ $histories->getTotal() }}</td>
                </tr>
              </tbody>
            </table>
            <p class="pull-right">{{ $histories->links() }}</p>
          </div>
        </div>
      </div>
    </div>
  </section>
@endsection
@section('addJs')
  {{ HTML::script('js/products.js')}}
@endsection
