@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      @if ($invoice->deposit > 0)
      {{ Trans('invoices.menu') }}
      @else
        {{ Trans('invoices.paid') }}
      @endif
      <small>{{ Trans('invoices.detail') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ route('invoices.index')}}"><i class="fa fa-info"></i> {{ trans('invoices.menu') }}</a></li>
      <li class="active"><a href="#">{{ Trans('invoices.detail')}}</a></li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
     @include('layouts.includes.message')
    <div class="row">
      <div class="col-md-5">
        @if(isset($customer))
          <div class="box">
            <div class="box-header with-border">
              <h3 class="box-title"><i class="fa fa-user"></i> {{ Trans('customers.menu')}}</h3>
            </div>
            <div class="box-body">
              <div class="row">
                <div class="col-md-8">
                  <table class="table table-striped table-bordered">
                    <tr>
                      <th>{{ Trans('invoices.full_name') }}
                      </th>
                      <td><a href="{{ route('customers.show', $customer->id)}}">{{ $customer->fullName() }}</a></td>
                    </tr>
                    <tr>
                      <th>{{ Trans('customers.tel') }}</th>
                      <td>{{ $customer->tel }}</td>
                    </tr>
                  </table>
                </div>
                <div class="col-md-4">
                  {{ HTML::image($customer->photo, $customer->first_name, [
                    'class' => 'img-responsive img-thumbnail',
                    ]) }}
                </div>
              </div>
            </div>
          </div>
        @endif

        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title"><i class="fa fa-money"></i> {{ Trans('invoices.menu')}}</h3>
          </div>
          <div class="box-body">
            <table class="table table-striped table-bordered">
              <tr>
                <th>{{ Trans('invoices.id') }}</th>
                <td>{{ InvoiceHelper::convertInvoiceNumber($invoice->id) }}</td>
              </tr>
              <tr>
                <th>{{ Trans('invoices.total') }}</th>
                <td>{{ money($invoice->total) }}</td>
              </tr>
              <tr>
                <th>{{ Trans('invoices.recieved') }}</th>
                <td>{{ money($invoice->recieved) }}</td>
              </tr>
              @if($invoice->changed > 0)
                <tr>
                  <th>{{ Trans('invoices.changed') }}</th>
                  <td>{{ money($invoice->changed) }}</td>
                </tr>
              @endif
              @if($invoice->deposit > 0)
                <tr>
                  <th>{{ Trans('invoices.deposit') }}</th>
                  <td>{{ money($invoice->deposit) }}</td>
                </tr>
              @endif
              <tr>
                <th>{{ Trans('invoices.created_at') }}</th>
                <td>{{ $invoice->created_at }}</td>
              </tr>
            </table>
          </div>
        </div>
      </div>
      <div class="col-md-7">
          @if ($invoice->deposit > 0 || (isset($payables) && count($payables) > 0))
              @include('Invoices.inc.form')
          @endif

        @if(isset($products) && count($products) > 0)
          @include('Invoices.inc.products')
        @endif
      </div>
    </div>
  </section>
@endsection
