@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('invoices.menu') }}
      <small>{{ Trans('dashboard.others.show_all') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active"><a href="{{ route('invoices.index') }}"><i class="fa fa-info"></i> {{ Trans('invoices.menu') }}</a></li>
      <li class="active"><a href="#">{{ Trans('dashboard.others.show_all')}}</a></li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    @if(Session::has('message'))
      <p class="alert alert-warning">
        {{ Trans(Session::get('message')) }}
      </p>
    @endif
    <div class="row">
      <div class="col-md-12">
        <div class="box box-body">
          {{ Form::open(['method' => 'get', 'action' => "search", 'class' => 'form-inline']) }}
          @include('Invoices.inc.datetime')
          <div class="checkbox">
            <?php
            $checked = false;
            Request::get('deposit') ? $checked = true : $checked;
             ?>
            <label>{{ Form::checkbox('deposit',1, $checked) }} {{ Trans('invoices.deposit') }}</label>
          </div>
          <button type="submit" class="btn btn-info pull-right"><i class="fa fa-search"></i> {{ Trans('invoices.search') }}</button>
          {{ Form::close() }}
          <hr>
          @if(isset($invoices) && count($invoices))
            @include('Invoices.inc.table')
          @else
          <p class="text-center alert alert-warning">
            No row return
          </p>
          @endif
          <div class="text-center">
          </div>
        </div>
      </div>
    </div>
  </section>
@endsection
@section('addJs')
  {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
  {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
  <script>
    $().datepicker({
      format: 'yyyy-mm-dd',
      language: 'kh'
    });
  </script>
@endsection
