<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Invoice V1</title>
	{{ HTML::style('css/bootstrap.css') }}
	{{ HTML::style('css/invoice.css') }}
	<style>
	hr {
		border: 0 !important;
	}
	table, td, th {    
    border: 1px solid #ddd;
    text-align: left;
	}

table {
    border-collapse: collapse;
    width: 100%;
}

th, td {
    padding: 10px;
    color: #000 !important;
}
th {
	font-weight: normal;
	font-size: 14px;
}
footer {
	position: absolute;
	bottom: 0;
	left: 25%;
}
.buyer, .seller {
	position: absolute;
	bottom: 70px;
}
.buyer {
	left: 10px;

}
.seller {
	right: 10px;
}
.date {
	position: absolute;
	bottom: 90px;
	right: 10px;
}
	@media print{
			.print-container{
				width: 100% !important;
				margin: 0;
			}
			@page {
  			size: A5;
  			margin: 0;
		}
		header.sale-v2-header .logo img {
    		width: 100px;
    		padding: 0;

		}
	}
	</style>
</head>
<script>
	//window.print();
</script>
<body>
	<div class="container invoice-v2 print-container">
		<div class="row">
			<div class="col-xs-4">
				<header class="sale-v2-header">
				<div class="logo pull-left">
					{{ HTML::image('uploads/rim.jpg', "Rim") }}
				</div>
				</header>
			</div>
			<div class="col-xs-4">
				<div class="invoice-address text-center">
					<h4 style="padding-top:20px;">{{ get_config('company_name')}}</h4>
				</div>
			</div>
			<div class="col-xs-4">
				<header class="sale-v2-header">
				<div class="logo pull-left">
					<div class="logo pull-left">
					{{ HTML::image('uploads/car.jpg', "Car") }}
				</div>
				</div>
				</header>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<p class="text-center" style="font-size: 13px;">{{ get_config('company_detail') }}</p>
			</div>
		</div>
		<br>
		<div class="row">
			<div class="col-xs-4">{{ get_config('company_address') }}</div>
			<div class="col-xs-4">
			<hgroup class="text-center">
				<h4 style="margin-top:0">{{ trans('invoices.menu') }}</h4>
				<h4>INVOICE</h4>

			</hgroup>
			
			</div>
			<div class="col-xs-4 text-right">
			No <b>{{ convertInvoiceNumber($invoice->id) }}</b>
			<br>
			Tel: {{ get_config('company_tel') }}
			</div>
		</div>
		<div>
			<table>
				<thead>
					<tr>
						<th>{{ trans('products.id') }}</th>
						<th>{{Trans('sale.name')}}</th>
						<th>{{Trans('sale.qty')}}</th>
						<th>{{Trans('sale.unit_price')}}</th>
						<th>{{Trans('sale.total')}}</th>
					</tr>
				</thead>
				<tbody>
				<?php $i=1;
								$totalPrice = 0; 
					 ?>
				@if (count($orders) > 0)
					
				  @foreach($orders as $order)
				    <tr>
							<?php $totalPrice += $order->amount * $order->price; ?>
				      <td>{{$i}}</td>
				      <td>{{ $order->name }}</td>
				      <td>{{ $order->amount}}</td>
							<td>{{ money($order->price) }}</td>
				      <td>{{ money($order->amount * $order->price)}}</td>
				    </tr>
				  <?php $i++; ?>
				  @endforeach
				 @endif
				</tbody>
			</table>
		</div>
		<div class="receipt-total">
			<div class="row">
				<div class="col-xs-6">
				<br>
					<p>{{ get_config('invoice_payment_term') }}</p>
				</div>
				<div class="col-xs-6">
					<br>
					<table>
						<tr>
							<th style="font-size:12px;">{{ trans('sale.g_total') }}</th>
							<td class="text-right">{{ money($totalPrice) }}</td> 
						</tr>
						@if ($invoice->changed > 0)
						<tr>
							<th style="font-size:12px;">{{ trans('invoices.changed') }}</th>
							<td class="text-right">{{ money($invoice->changed) }}</td> 
						</tr>
						@endif
						@if ($invoice->deposit > 0)
						<tr>
							<th style="font-size:12px;">{{ trans('sale.deposit') }}</th>
							<td class="text-right">{{ money($invoice->deposit) }}</td> 
						</tr>
						@endif
					</table>
				</div>
			</div>
		</div>	
		<hr>
		<div class="date">
			{{ trans('invoices.created_at') }} : {{ $invoice->created_at }}
		</div>
		<div class="buyer">
			{{ trans('sale.buyer') }} / The Buyer
		</div>
		<div class="seller">
			{{ trans('sale.seller') }} / The Seller
		</div>
		<footer>
		<p class="text-center">Powered by The Coder Studio &copy; {{ date('Y') }}. All rights reserved.</p>
		
		</footer>
	</div>
</body>
</html>
