<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Invoice V1</title>
	{{ HTML::style('css/bootstrap.css') }}
	{{ HTML::style('css/invoice.css') }}
	<style>
		@media print{
			.print-container{
				width: 100% !important;
				margin: 0;
			}
			@page {
  size: A5;
  margin: 0;
}
header.sale-v2-header .logo img {
    width: 100px;
    padding: 0;

}
		}
	</style>
</head>
<script>
	window.print();
</script>
<body>
	<div class="container invoice-v2 print-container">
		<div class="row">
			<div class="col-xs-4">
				<header class="sale-v2-header">
				<div class="logo pull-left">
					<img src="{{get_config('company_logo')}}" alt="Logo" class="responsive-img logo"/>
				</div>
				</header>
			</div>
			<div class="col-xs-8">
				<div class="invoice-address text-right">
					<h4>{{ get_config('company_name')}}</h4>
					<p>{{ get_config('company_address')}}</p>
					<p>{{Trans('customers.tel')}} : {{ get_config('company_tel')}}</p>
					@if(!empty(get_config('company_facebook')))
						<p>{{ get_config('company_facebook')}}</p>
					@endif
					@if(!empty(get_config('company_website')))
						<p>{{Trans('settings.company_website')}} : {{ get_config('company_website')}}</p>
					@endif
				</div>
			</div>
		</div>
		<div class="row invoice-bill">
			<div class="col-xs-5 customer-details">
				<h5>{{Trans('sale.bill_to')}}</h5>
						@if($customer)
							<p>{{ $customer->first_name." ".$customer->last_name }}</p>
							@if(!empty($customer->address))
								<p>{{$customer->address}}</p>
							@endif
							@if(!empty($customer->tel))
								<p>{{$customer->tel}}</p>
							@endif
							@if(!empty($customer->email))
								<p>{{$customer->email}}</p>
							@endif
						@else
							<p>{{Trans('customers.menu')." : ".Trans('customers.general') }}</p>
						@endif
			</div>
			<div class="col-xs-7">
				<div class="col-xs-5">
					<h5>{{Trans('sale.sale_receipt')}}</h5>
					<ul class="reset-list">
						<li>{{Trans('sale.date')}}:</li>
						<li>{{Trans('sale.issue_by')}}:</li>
					</ul>
				</div>
				<div class="col-xs-7 text-right">
					<h5>#{{InvoiceHelper::convertInvoiceNumber($invoice->id)}}</h5>
					<ul class="reset-list">
						<li>{{ $invoice->updated_at}}</li>
						<li>{{getField('User','id',$invoice->user_id,'first_name')}} {{getField('User','id',$invoice->user_id,'last_name')}}</li>
					</ul>
				</div>
			</div>
		</div>
		<div class="invoice-table">
			<table class="table">
				<thead>
					<tr>
						<th>No</th>
						<th>{{Trans('products.sku')}}</th>
						<th>{{Trans('products.name')}}</th>
						<th>{{Trans('sale.qty')}}</th>
						<th>{{Trans('products.discount')}}</th>
						<th>{{Trans('sale.unit_price')}}</th>
						<th>{{Trans('sale.total')}}</th>
					</tr>
				</thead>
				<tbody>
					<?php $i=1; ?>
				  @foreach($orders as $order)
				    <tr>

				      <td>{{$i}}</td>
				      <td>{{getField('Product','id',$order->product_id,'sku')}}</td>
				      <td>
				        {{getField('Product','id',$order->product_id,'name')}}
				      </td>
				      <td>{{$order->amount}}
				      {{ getField('Unit','id',getField('Product','id',$order->product_id,'unit_id'),'name') }}</td>

				      <td><?php
				          if($order->discount > 0 ) {
				            echo $order->discount. "%";
				          }
				          else {
				          	echo  "0%";
				          }
				        ?></td>
						<?php $mprice = (get_config('invoice_currency') == "riel") ? money($order->price*get_config('invoice_rate')) : money($order->price); ?>
				       <?php $tprice = (get_config('invoice_currency') == "riel") ? money($order->amount * ($order->price*get_config('invoice_rate'))) : money($order->amount * $order->price); ?>
				      <td>{{$mprice}}</td>
				      <td>{{$tprice}}</td>
				    </tr>
				  <?php $i++; ?>
				  @endforeach
				</tbody>
			</table>
		</div>
		<div class="receipt-total">
			<div class="row">
				<div class="col-xs-5 col-xs-offset-7">
					<ul class="clearfix reset-list">
						<li>
							<div class="float-left">
								{{Trans('sale.total')}}
							</div>
							<div class="float-right">
								{{money($invoice->total)}}
							</div>
						</li>
						{{-- Subtotal Option --}}
						<li>
							<div class="float-left">
								{{ trans('sale.total')}}{{ Trans('sale.'.get_second_currency()) }}
							</div>
							<div class="float-right">
								{{money($invoice->total*get_config('invoice_rate'), getCurrencySign(get_second_currency()))}}
							</div>
						</li>
						@if ($invoice->changed > 0)
						<hr>
						<li>
							<div class="float-left">
								{{Trans('sale.change_money')}}
							</div>
							<div class="float-right">
								<span class="bold-text">{{money($invoice->changed)}}</span>
							</div>
							<div class="clearfix"></div>
							<div class="float-left">
								{{Trans('sale.change_money')}}{{ trans('sale.'.get_second_currency())}}
							</div>
							<div class="float-right">
								<span class="bold-text">{{ money($invoice->changed*get_config('invoice_rate'), getCurrencySign(get_second_currency())) }}</span>
							</div>
						</li>
						@endif
						@if ($invoice->deposit > 0)
						<li>
							<div class="float-left">
								{{Trans('sale.receivable_amount')}}
							</div>
							<div class="float-right">
								<span class="bold-text">{{ money($invoice->deposit)}}</span>
							</div>
						</li>
						@endif
					</ul>

				</div>
			</div>
		</div>
		<hr>
		<p class="pull-right">{{ trans('sale.exchange_rate')}} 1 {{getCurrencySign()}} =  {{money(get_config('invoice_rate'), getCurrencySign(get_second_currency()))}}</p><div class="clearfix"></div>
		<div class="invoice-notice">
			@if(!empty(get_config('invoice_payment_term')))
			<p class="alert alert-info"><span class="bold-text">Notes:
				</span>
					{{ get_config('invoice_payment_term')}}
				</span>
			</p>
			@endif
			@if(!empty(get_config('invoice_client_note')))
				<p class="text-center">{{ get_config('invoice_client_note')}}</p>
			@endif
			@if(!empty(get_config('invoice_footer')))
				<p class="text-center">{{ get_config('invoice_footer')}}</p>
			@endif
		</div>
		<hr>
		<footer>
		<p class="text-center">Powered by The Coder Studio &copy; 2016. All rights reserved.</p>
		<p class="text-center">Tel : 053 732 390 / 016 96 88 29 </p>
	</footer>
	</div>
	@if(get_config('turn_off_print_dialog') == "yes")
		<script type="text/javascript">
		  window.close();
		</script>
	@endif
</body>
</html>
