<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Invoice V1</title>
	{{ HTML::style('css/bootstrap.css') }}
	{{ HTML::style('css/invoice.css') }}
	<style>
		{{ Helper::getConfig('custom_style') }}
	</style>
</head>
<script>
window.print();
</script>
<body>
	<header class="sale-v1-header">
		<div class="logo">
			<img src="{{Helper::getConfig('company_logo')}}" alt="Logo" class="responsive-img logo"/>
		</div>
		<h2 class="text-center company-name">{{ Helper::getConfig('company_name')}}</h2>
		<div class="text-center header-address">
			<p>{{ Helper::getConfig('company_address')}}</p>
			<p>{{Trans('customers.tel')}} : {{ Helper::getConfig('company_tel')}}</p>
			@if(!empty(Helper::getConfig('company_facebook')))
				<p>{{ Helper::getConfig('company_facebook')}}</p>
			@endif
			@if(!empty(Helper::getConfig('company_website')))
				<p>{{Trans('settings.company_website')}} : {{ Helper::getConfig('company_website')}}</p>
			@endif
		</div>
	</header>
	<hr>
	<div class="container-fluid invoice-v1">
		<div class="row sale-receipt">
			<h2 class="text-center">{{ Trans('sale.sale_receipt')}}</h2>
			<div class="col-xs-6">
				<ul class="reset-list">
					<li><span class="bold-text">#{{InvoiceHelper::convertInvoiceNumber($invoice->id)}}</span></li>
					<li>{{Trans('sale.cashier')}}: <span class="bold-text">{{getField('User','id',$invoice->user_id,'first_name')}}</span></li>
				</ul>
			</div>
			<div class="col-xs-6">
				<ul class="reset-list text-right">
					<li>{{ date('Y-m-d h:i:s')}}</li>
					<?php
						if(!empty($invoice->customer_id) && $invoice->customer_id <> 0)
							$customer = getField('Customer','id',$invoice->customer_id,'first_name');
						else
							$customer = Trans('customers.general');
					?>
					<li>{{Trans('customers.menu')}}: 
						<span class="bold-text">{{$customer}}</span>
					</li>
				</ul>
			</div>
		</div>
		
		<div class="receipt-table">
			<table class="table table-striped">
				<thead>
					<tr>
						<td>No</td>
						<th>{{Trans('products.name_kh')}}</th>
						<th>{{Trans('sale.qty')}}</th>
						<th>{{Trans('sale.unit_price')}}</th>
						<th>{{Trans('sale.total')}}</th>	
					</tr>
				</thead>
				<tbody>
					<?php $i=1; ?>
				  @foreach($orders as $order)
				    <tr>
				      <td>{{$i}}</td>
				      <td>
				        {{getField('Product','id',$order->product_id,'name')}}
				        <br/><span>{{getField('Product','id',$order->product_id,'name_kh')}}</span>
				        <span>
				        <?php
				          if($order->discount > 0 ) {
				            echo Trans('products.discount') . $order->discount. "%";
				          }
				        ?>
				        </span>
				      </td>
				      <td>{{$order->amount}} 
							{{ getField('Unit','id',getField('Product','id',$order->product_id,'unit_id'),'name') }}
				      </td>
				      <td>{{ money($order->price) }}</td>
				      <td>{{ money($order->price * $order->amount) }}</td>
				    </tr>
				  <?php $i++; ?>
				  @endforeach
				</tbody>
			</table>
		</div>
		<div class="row receipt-total text-right">
			<div class="col-xs-12 col-sm-9  col-sm-offset-3">
				<div class="col-xs-6">
					<ul class="reset-list">
						<li>{{Trans('sale.subtotal')}} :</li>
						<li>{{Trans('sale.tax')}} :</li>
						<li>{{Trans('sale.total')}} :</li>
						{{ Trans('sale.total') }} {{ getCurrencySign(get_second_currency()) }}
					</ul>
				</div>
				<div class="col-xs-6">
					<ul class="reset-list">
						<li>{{money(InvoiceHelper::getTotal($invoice->id))}}</li>
						<li>{{$invoice->tax}}%</li>
						<li>{{money($invoice->total)}}</li>
						<li>{{money($invoice->total*Helper::getConfig('invoice_rate'), getCurrencySign(get_second_currency())) }}
						</li>
					</ul>
				</div>
			</div>
			<div class="cash">
				<div class="col-xs-12 col-sm-9  col-sm-offset-3">
					<hr>
					<div class="col-xs-6 cash-text">
						{{Trans('sale.received_cash')}} :

					</div>
					<div class="col-xs-6 cash-text">
						{{ money($invoice->recieved_dollar)}}
					</div>
					<hr>
					<div class="col-xs-6 cash-text">
						{{Trans('sale.received_cash')}} {{getCurrencySign(get_second_currency()) }}: 
					</div>
					<div class="col-xs-6 cash-text">
						{{ money($invoice->recieved_riel, getCurrencySign(get_second_currency()))}}
					</div>
				</div>
				<div class="col-xs-12 col-sm-9  col-sm-offset-3">
					<hr>
					<div class="col-xs-6 cash-text">
						{{Trans('sale.receivable_amount')}} :
					</div>
					<div class="col-xs-6 cash-text">
						{{ money($invoice->deposit,getCurrencySign())}}
					</div>
				</div>
				<div class="col-xs-12 col-sm-9  col-sm-offset-3">
					<hr>
					<div class="col-xs-6 cash-text">
						{{Trans('sale.change_money')}} :
					</div>
					<div class="col-xs-6 cash-text">
						{{money($invoice->changed,getCurrencySign())}} = {{number_format( $invoice->changed * $invoice->rate,2)}} {{getCurrencySign(get_second_currency())}}
					</div>
				</div>
			</div>
			
		</div>
		<div class="thank text-center"><br/>
			<p class="lead">
				{{ trans('sale.exchange_rate')}} 1{{ getCurrencySign() }} =  {{money($invoice->rate,getCurrencySign(get_second_currency())) }}
			</p>
			<p class="center-align">{{ Helper::getConfig('invoice_client_note')}}</p>
			<p class="center-align">{{ Helper::getConfig('invoice_payment_term')}}</p>
		</div>
	</div>
	<footer>
		<p class="text-center">Powered by The Coder Studio &copy; 2016. All rights reserved.</p>
		<p class="text-center">Tel : 053 732 390 / 016 96 88 29 </p>
	</footer>
</body>
@if(Helper::getConfig('turn_off_print_dialog') == "yes")
	<script type="text/javascript">
	  window.close();
	</script>
@endif
</html>