<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Quotation</title>
	{{ HTML::style('css/bootstrap.css') }}
<style>
	/* Print Only */
	@media print{
			.print-container{width: 100% !important;margin: 0;}
			@page {size: A5;margin: 0;}
		header.sale-v2-header .logo img {width: 100px;padding: 0;}
	}
	body { font-size: 12px; }
  .font-kh { font-family: "Khmer OS Fasthand"; }
	h2 { font-family: "Khmer OS Muol" !important;color: blue;}
	h3 { color: red; }
	table, th {border: 1px solid #000;text-align: left;}
	hr { border: 0 !important;}
	table {border-collapse: collapse; width: 100%;}
	th { font-weight: bold !important;}
	th { padding: 5px;color: #000 !important; }
	td { vertical-align: top; padding: 2.5px; border-left: 1px solid #000; }
	th { font-weight: normal; font-size: 12px;}
	.buyer, .seller { position: absolute; bottom: 70px; }
	.buyer { left: 10px;}
	.seller { right: 10px;}
	.date { position: absolute; bottom: 90px; right: 10px;}
	.border { border: 0; border-bottom: 3px solid #080808;margin-bottom: 0 !important;padding-bottom: 10px;}
	.detail { font-size: 14px; }
	table.no-border, .no-border th, .no-border td {border: 0 !important;padding: 2px !important;}
		footer p { padding: 0 !important;margin-bottom: 0 !important;}
		footer { page-break-inside: avoid; }
		li { font-size: 12px; }
		.ruler {border: 0; border-bottom: 1px solid #080808; margin-bottom: 0 !important; padding-bottom: 10px; position: absolute;width: 100%;bottom: 65px;left: 0;}
		.sign {
			border-top: 1px solid #000 !important;
		}
		footer { padding-top: 10px; }
		.content { min-height: 365px !important; }
		/*.container { width: 600px; }*/
	</style>
</head>
<script>
	 window.print();
</script>
<body>
	<div class="container">
		<div class="row">
			<div class="col-xs-4">
				<header class="sale-v2-header">
				<div class="logo pull-left">
					{{ HTML::image('uploads/network.jpg', "Network Computer Shop", [
							'width' => '100px',
							'style' => "padding-top: 10px;"
					]) }}
				</div>
				</header>
			</div>
			<div class="col-xs-8">
				<div class="invoice-address text-center">
					<hgroup>
						<h2>{{ get_config('company_name') }}</h2>
						<h3>NETWORK COMPUTER</h3>
					</hgroup>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<p class="text-center detail border font-kh">{{ get_config('company_detail') }}</p>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-6">
				<h5 class="font-kh">{{ trans('customers.menu') }}/ Customer</h5>
				<table class="no-border">
					<tr>
						<th style="width: 40px;">Name</th>
						<td>: {{ get_c_q($quotation->id) }}</td>
					</tr>
					<tr>
						<th>Address</th>
						@if ($quotation->address)
						<td>{{ $quotation->tel }}</td>
						@else 
						<td>: ..........................................</td>
						@endif
					</tr>
					<tr>
						<th>Tel</th>
						@if ($quotation->tel)
						<td>{{ $quotation->tel }}</td>
						@else 
						<td>: ..........................................</td>
						@endif
					</tr>
				</table>
			</div>
			<div class="col-xs-6">
				<h3 class='text-right' style="margin-top: 10px;">QUOTATION</h3>
				<p class="text-right font-kh">{{ trans('quotations.quot_no') }}/ N<sup>0</sup>: <b>{{ convertInvoiceNumber($quotation->id) }}</b></p>
				<p class="text-right font-kh">{{ trans('quotations.date') }}/ Date: {{ $quotation->created_at }}</p>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12">
						<table>
						<thead>
							<tr>
								<th style="width: 15%;" class="text-center">N<sup>o<sup></th>
								<th style="width: 40%">Description</th>
								<th style="width: 9%">Qty</th>
								<th style="width: 13%;">Price</th>
								<th style="width: 13%;">Amount</th>
							</tr>
						</thead>
						<tbody>
						@if (count($preOrders) > 0)
							<?php 
								$total = 0;
								$i = 1;
								$totalOrders = 0;
							 ?>
							@foreach ($preOrders as $order)
							<?php $total += $order->amount * $order->price; ?>
							<tr>
								<td class="text-center">{{ $order->sku }}</td>
								<td>{{ $order->name }}</td>
								<td>{{ $order->amount }}</td>
								<td>{{ money($order->price) }}</td>
								<td>{{ money($order->amount * $order->price) }}</td>
							</tr>
							<?php $totalOrders += get_q_line($order->name); ?> 
							@endforeach							
							 @if ($totalOrders <= 13)
								 @for ($i= $totalOrders+1; $i<= 13; $i++) 
									<tr>
										<td>&nbsp;</td>
										<td>&nbsp;</td>
										<td>&nbsp;</td>
										<td>&nbsp;</td>
										<td>&nbsp;</td>
									</tr>
								 @endfor
							@endif
						@endif
						</tbody>
					</table>
			</div>
		</div>
		<footer>
			<div class="row">
				<div class="col-xs-8">
					<b>THANK YOU for shopping with NETWORK {{ $totalOrders }}</b>
					<ul>
						<li>Goods sold are not refundable</li>
						<li>Please check your goods before leaving!</li>
						<li>PAYMENT. ANZ Bank (A/C : HEM KOSAL, 1378583)</li>
					</ul>
				</div>
				<div class="col-xs-4">
					<table class="no-border">
						<tr>
							<th>Total $</th>
							<td>{{ money($total) }}</td>
						</tr>
						<tr>
							<th>Total R</th>
							<td>{{ money($total * get_config("invoice_rate"), "៛") }}</td>
						</tr>
					</table>
				</div>
			</div>
			<br>
			<div class="row">
				<div class="col-xs-6">
					<p class="text-center sign">Customer's Signature</p>
				</div>
				<div class="col-xs-6">
					<p class="text-center sign">Authorize Signature</p>
				</div>
			</div>	
			<div class="row">
				<div class="col-xs-12">
					<p class="text-center font-kh" style="font-size: 11px; padding-top: 10px">អស័យដ្ឋាន: ផ្ទះលេខ 095, ផ្លូវលេខ 123​​ រឺ(ផ្លូវ២ធ្នូ) ស.ក កំពង់ក្របី, (ខាងកើតសាលា២ធ្នូ 50ម)</p>
					<p class="text-center" style="font-size:16px; font-weight: bold;">Office: 053 953 124 or H/P 097 799 5969, 089 655 597</p>
				</div>
			</div>
		</footer>
	</div>
	@if(get_config('turn_off_print_dialog') == "yes")
		<script type="text/javascript">
		  window.close();
		</script>
	@endif
</body>
</html>