<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Invoice</title>
	{{ HTML::style('css/bootstrap.css') }}
<style>
  body { font-family: "Helvetica Neue", Helvetica, Arial, sans-serif; }
	/* Print Only */
	@media print{
			.print-container{width: 100% !important;margin: 0;}
			@page {size: A5;margin: 0;}
		header.sale-v2-header .logo img {width: 100px;padding: 0;}
	}
	body { font-size: 12px; }
  .font-kh { font-family: "Khmer OS Fasthand"; }
	.invoice-address h2 { font-size: 22px; font-weight: bold; margin-bottom: 5px;}
	.invoice-address h3 { font-size: 16px; font-weight: bold; margin-top: 0; margin-bottom: 0;}
	table, td, th {border: 1px solid #000;text-align: left;}
	hr { border: 0 !important;}
	table {border-collapse: collapse; width: 100%;}
	th { font-weight: bold !important; padding: 5px;}
	td { padding: 0px; padding-left: 5px; padding-right: 5px; color: #000 !important;  vertical-align: top;}
	th { font-weight: normal; font-size: 12px;}
	.buyer, .seller { position: absolute; bottom: 70px; }
	.buyer { left: 10px;}
	.seller { right: 10px;}
	.date { position: absolute; bottom: 90px; right: 10px;}
	.border { border: 0; border-bottom: 2px solid #080808;margin-bottom: 0 !important;padding-bottom: 5px; }
	.detail { font-size: 14px; }
	table.no-border th, .no-border td {border: 0 !important;padding: 2.5px !important;}
		footer p { padding: 0 !important;margin-bottom: 0 !important;}
		li { font-size: 12px; }
		.ruler {border: 0; border-bottom: 1px solid #080808; margin-bottom: 0 !important; padding-bottom: 10px; position: absolute;width: 100%;bottom: 65px;left: 0;}
		p.sign {
			padding-top: 5px !important;
		}
		.content { min-height: 330px !important; }
		.content td { border: 0; border-right: 1px solid #000; }
		.invoice-address p { margin-bottom: 0;}
		footer { padding-top: 20px; }
		.term, .term ul li{ font-size: 8px; }
		.term ul { padding-left: 10px; }
		.term ul li { list-style-type: circle;}
		.total th, .total tr { font-size: 11px !important; font-weight: bold !important;  text-align: right !important;}
	</style>
</head>
<script>
	// window.print();
</script>
<body>
	<div class="container invoice-v2 print-container">
		<div class="row">
			<div class="col-xs-12">
				<div class="invoice-address">
					<hgroup class="text-center">
						<h2>{{ get_config('company_name') }}</h2>
						<h3>{{ get_config('company_detail') }}</h3>
					</hgroup>
					<p class="text-center" style="font-size: 14px; padding: 5px;">{{ get_config('company_address') }}</p>
					<p class="text-center lead">{{ trans('settings.company_tel') }} {{ get_config('company_tel') }}</p>

				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-6">
				<table class="no-border" style="margin-top: 5px; border:1px solid #000;">
					<tr>
						<th style="width: 100px;"">{{ trans('customers.menu') }}</th>
						@if ($invoice->customer_id)
							<td>: {{ $invoice->first_name }} {{ $invoice->last_name }}</td>
						@else
							<td>: {{ trans('customers.general') }}</td>
						@endif
					</tr>
					<tr>
						<th>{{ trans('customers.tel') }}</th>
						<td>: {{ $invoice->tel }}</td>
					</tr>
					<tr>
						<th>{{ trans('customers.address') }}</th>
						<td>: {{ $invoice->address }}</td>
					</tr>
				</table>
			</div>
			<div class="col-xs-6">
				<table class="no-border" style="margin-top: 5px; border:1px solid #000;">
					<tr>
						<th style="width: 100px;"">{{ trans('sale.no') }}</th>
						<td>: {{ convertInvoiceNumber($invoice->id) }}</td>
					</tr>
					<tr>
						<th>{{ trans('sale.date') }}</th>
						<td>: {{ $invoice->created_at }}</td>
					</tr>
					<tr>
						<th>{{ trans('sale.issue_by') }}</th>
						<td>: {{ $invoice->funame }} {{ $invoice->luname }}</td>
					</tr>
				</table>
			</div>
		</div>
		<br>
		<div class="row">
			<div class="col-xs-12">
				<h3 class="text-center" style="margin-top: 0; font-size: 18px; font-weight: bold;">{{ trans('invoices.menu') }}</h3>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 content">
						<table>
						<thead>
							<tr>
								<th style="width: 5%;">N<sup>o<sup></th>
								<th style="width: 15%;">{{ trans('products.sku') }}</th>
								<th>{{ trans('products.name') }}</th>
								<th>{{ trans('products.amount') }}</th>
								<th style="width: 15%;">{{ trans('sale.unit_price') }}</th>
								<th style="width: 20%;">{{ trans('sale.total') }}</th>
							</tr>
						</thead>
						<tbody>
						@if (count($orders) > 0)
							<?php 
								$total = 0;
								$i = 1;
							 ?>
							@foreach ($orders as $order)
							<?php $total += $order->amount * $order->price; ?>
							<tr>
								<td>{{ $i; }}</td>
								<td>{{ $order->sku }}</td>
								<td>{{ $order->name }}</td>
								<td>{{ $order->amount }}</td>
								<td>{{ money($order->price) }}</td>
								<td>{{ money($order->amount * $order->price) }}</td>
							</tr>
							<?php $i++; ?>
							@endforeach
							<?php $totalOrders = count($orders); ?> 
							 @if ($totalOrders <= 15)
								 @for ($i= $totalOrders+1; $i<= 15; $i++) 
								<tr>
									<td>&nbsp;</td>
									<td>&nbsp;</td>
									<td>&nbsp;</td>
									<td>&nbsp;</td>
									<td>&nbsp;</td>
									<td>&nbsp;</td>
								</tr>
						 @endfor
					@endif
						@endif
						</tbody>
					</table>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-7">
					<div class="row">
						<div class="col-md-12">
							<p style="font-weight: bold;">{{ trans('sale.note') }} :</p>
							{{ get_config("invoice_payment_term") }}
						</div>
					</div>
			</div>
			<div class="col-xs-5">
				<table class="no-border total" style="border: 0;">
					<tr>
						<th>{{ trans('sale.total_riel') }} </th>
						<td class="text-right">{{ money($invoice->total) }}</td>
					</tr>
					<tr>
						<th>{{ trans('sale.total_usd') }} </th>
						<td class="text-right">{{ money($invoice->total / get_usd_rate(), "$") }}</td>
					</tr>
					@if ($invoice->recieved_dollar > 0)
					<tr>
						<th>{{ trans('sale.received_cash') }} </th>
						<td class="text-right">{{ money($invoice->recieved_dollar) }}</td>
					</tr>
					@endif
					@if ($invoice->recieved_riel > 0)
					<tr>
						<th>{{ trans('sale.received_cash') }} </th>
						<td class="text-right">{{ money($invoice->recieved_riel, "$") }}</td>
					</tr>
					@endif
					@if ($invoice->changed > 0)
					<tr>
						<th>{{ trans('sale.changed') }} </th>
						<td class="text-right">{{ money($invoice->changed) }}</td>
					</tr>
					@endif
				</table>
			</div>
		</div>	
		<footer>
			<div class="row">
				<div class="col-xs-6">
					<p class="sign">{{ trans('sale.buyer') }}</p>
				</div>
				<div class="col-xs-6">
					<p class="sign">{{ trans('sale.seller') }}</p>
				</div>
			</div>
		</footer>
	</div>
	@if(get_config('turn_off_print_dialog') == "yes")
		<script type="text/javascript">
		  window.close();
		</script>
	@endif
</body>
</html>