<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Invoice V1</title>
	{{ HTML::style('css/bootstrap.css') }}
	<style>
		h1 { font-size: 18px; border-bottom: 2px solid #000;
			padding-bottom: 10px;}
		table tr td { padding: 5px;}
		hr { border-color: #000 !important; margin-bottom: 5px !important; margin-top: 0 !important;}
		.table-bordered, .table-bordered tr td, .table-bordered tr th {
			border: 1px solid #000 !important;}
		ul li { list-style-type: none; padding: 5px;}
		.container	{ width: 960px; border: 1px solid #ddd; }
		th { font-weight: normal !important; }
		#check { border: 1px solid #000;width: 15px;height: 15px;padding: 5px;display: inline-block;}
		.note {font-weight: bold !important;}
	</style>
	<style media="print">
		@page {
			size: A4;
			margin: 10px;
			margin-left: 10px;
		}
		.container {
			border: 0 !important;
		}
		h1 { font-size: 18px; border-bottom: 2px solid #000;
			padding-bottom: 10px; margin-top: 5px;}
		table tr td { padding: 5px;}
		hr { border-color: #000 !important; margin-bottom: 5px !important; margin-top: 0 !important;}
		.table-bordered, .table-bordered tr td, .table-bordered tr th {
			border: 1px solid #000 !important;}
		ul li { list-style-type: none; padding: 5px;}
		.container	{ width: 960px; border: 1px solid #ddd; }
		th { font-weight: normal !important; }
		#check { border: 1px solid #000;width: 15px;height: 15px;padding: 5px;display: inline-block;}
		.note {font-weight: bold !important;}
	</style>
</head>
<script>
	//window.print();
</script>
<body>
	<div class="container">
	<!--Header-->
		<div class="row">
			<div class="col-xs-12">
				<h1 class="text-center">{{ get_config('invoice_title') }}</h1>
			</div>
			<div class="col-xs-8">
				<hgroup>
					<h2>{{ get_config('company_name') }}</h2>
					<h3>{{ get_config('company_address') }}</h3>
				</hgroup>
			</div>
			<div class="col-xs-4">
				<ul>
					<li><div id="check"></div> {{ trans('new_invoices.type1') }}</li>
					<li><div id="check"></div> {{ trans('new_invoices.type2') }}</li>
					<li><div id="check"></div> {{ trans('new_invoices.type3') }}</li>
				</ul>
			</div>
		</div>
		<hr>
		<div class="row" style="margin-bottom: 5px;">
			<div class="col-xs-3">{{ trans('new_invoices.id') }}.......................................</div>
			<div class="col-xs-3">{{ trans('new_invoices.doc') }}.......................................</div>
			<div class="col-xs-3">{{ trans('new_invoices.date') }}: {{ $invoice->created_at }}</div>
			<div class="col-xs-3 text-right">{{ trans('new_invoices.no') }}: {{ convertInvoiceNumber($invoice->id) }}</div>
		</div>
		<div class="row">
			<div class="col-xs-6">
				<table>
					<tr>
						<th>{{ trans('new_invoices.customer') }}</th>
						<td>.....................................................</td>
					</tr>
					<tr>
						<th>{{ trans('new_invoices.address') }}</th>
						<td>.....................................................</td>
					</tr>
					<tr>
						<th>{{ trans('new_invoices.tel') }}</th>
						<td>.....................................................</td>
					</tr>
				</table>
			</div>
			<div class="col-xs-3">
				<table class="table table-bordered">
					<tr>
						<td>{{ trans('new_invoices.p_type') }}</td>
					</tr>
					<tr>
						<td>{{ trans('new_invoices.serie') }}</td>
					</tr>
				</table>
			</div>
			<div class="col-xs-3">
				<table class="table table-bordered">
					<tr>
						<th>{{ trans('new_invoices.money')}}</th>
					</tr>
					<tr>
						<td style="padding-left: 40px;"><div id="check"></div>  {{ trans('new_invoices.riel') }}</td>
					</tr>
					<tr>
						<td style="padding-left: 40px;"><div id="check"></div>  {{ trans('new_invoices.baht') }}</td>
					</tr>
					<tr>
						<td style="padding-left: 40px;"><div id="check"></div>  {{ trans('new_invoices.usd') }}</td>
					</tr>
				</table>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<table class="table table-bordered">
					<thead>
						<tr>
							<th>{{ trans('new_invoices.id') }}</th>
							<th>{{ trans('new_invoices.barcode') }}</th>
							<th>{{ trans('new_invoices.p_name') }}</th>
							<th>{{ trans('new_invoices.location') }}</th>
							<th>{{ trans('new_invoices.hold_on_amount') }}</th>
							<th>{{ trans('new_invoices.unit_price') }}</th>
							<th>{{ trans('new_invoices.receive_amount') }}</th>
							<th>{{ trans('new_invoices.total') }}</th>
						</tr>
					</thead>
					<tbody>
					<?php $i=1; ?>
					@foreach ($orders as $order)
						<tr>
							<td>{{ $i }}</td>
							<td>{{ $order->barcode_alternative }}</td>
							<td>{{ $order->name }}</td>
							<td>{{ $order->location }}</td>
							<td>{{ $order->amount }} {{ $order->unit }}</td>
							<td>{{ money($order->price) }}</td>
							<td>{{ $order->amount - owe_amount($order->product_id, $order->invoice_id) }} {{ $order->unit }}</td>
							<td>{{ money($order->amount * $order->price)}}</td>
						</tr>
						<?php $i++; ?>
					@endforeach
					<?php $totalOrders = count($orders); ?> 
					 @if ($totalOrders <= 15)
						 @for ($i= $totalOrders+1; $i<= 15; $i++) 
						<tr>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
						</tr>
						 @endfor
					@endif
					</tbody>
				</table>
			</div>
			<div class="col-xs-8">
				<p>{{ trans('new_invoices.p_for_customer')}}</p>
				<table class="table table-bordered">
					<tr>
						<th style="width:30%">{{ trans('new_invoices.id_hold_on') }}</th>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
					</tr>
					<tr>
						<th>{{ trans('new_invoices.amount') }}</th>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
					</tr>
				</table>
			</div>
			<div class="col-xs-4">
				<table class="table table-bordered">
					<tr>
						<th>{{ trans('new_invoices.money') }}</th>
						<td>{{ money($invoice->total) }}</td>
					</tr>
					<tr>
						<th>{{ trans('new_invoices.tax') }}</th>
						<td>0</td>
					</tr>
					<tr>
						<th>{{ trans('new_invoices.total') }}</th>
						<td>{{ money($invoice->total) }}</td>
					</tr>
				</table>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<table class="table table-bordered">
					<tr>
						<td style="width:50%">{{ trans('new_invoices.date_send') }}</td>
						<td>{{ trans('new_invoices.note') }} </td>
					</tr>
				</table>
			</div>
			<div class="col-xs-12">
				<table class="table table-bordered" style="margin-bottom:5px;">
					<tr>
						<td>
							{{ trans('new_invoices.total_sale') }}
								<ul>
									<li><div id="check"></div> {{ trans('new_invoices.deposit') }}</li>
									<li><div id="check"></div> {{ trans('new_invoices.no_deposit') }}</li>
								</ul>
								{{ trans('new_invoices.money') }}.................. <br>
								{{ trans('new_invoices.total_deposit') }}..................
						</td>
						<td>
							{{ trans('new_invoices.received_deposit') }} <br>
							<div class="text-center">
								{{ trans('new_invoices.signature') }} <br><br><br>
							</div>
							{{ trans('new_invoices.date') }}..................
						</td>
						<td>
							{{ trans('new_invoices.received_seller') }} <br>
							<div class="text-center">
								{{ trans('new_invoices.signature') }} <br><br><br>
							</div>
							{{ trans('new_invoices.date') }}..................
						</td>
						<td>
							{{ trans('new_invoices.received_products') }} <br>
							<div class="text-center">
								{{ trans('new_invoices.signature') }} <br><br><br>
							</div>
							{{ trans('new_invoices.date') }}..................
						</td>
					</tr>
					<tr>
						<td colspan="4">
							<p class="text-center note">{{ get_config('invoice_client_note') }}</p>
						</td>
					</tr>
				</table>
				<div style="text-align:right;">{{ get_config('invoice_footer') }}</div>
			</div>
		</div>
	</div>
</body>
</html>
