@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('invoices.menu') }}
      <small>{{ Trans('dashboard.others.show_all') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active"><a href="{{ route('invoices.index') }}"><i class="fa fa-info"></i> {{ Trans('invoices.menu') }}</a></li>
      <li class="active"><a href="#">{{ Trans('dashboard.others.show_all')}}</a></li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    @include('layouts.includes.message')
    <div class="row">
      <div class="col-md-12">
        <div class="box box-body">
          @include('Invoices.inc.form_search')
          <hr>
          @if(isset($invoices) && count($invoices))
            @include('Invoices.inc.table')
          @else
          <p class="text-center text-warning">
            {{ trans('invoices.no_invoice') }}
          </p>
          @endif
          <div class="text-center">
            {{ $invoices->appends(Request::except('page'))->links() }}
          </div>
        </div>
      </div>
    </div>
  </section>
@endsection
@section('addJs')
  {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
  {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
  <script>
    $().datepicker({
      format: 'yyyy-mm-dd',
      language: 'kh'
    });
  </script>
@endsection
