<table class="table table-striped table-bordered">
  <thead>
    <tr>
      <th>{{ Trans('invoices.id') }}</th>
      <th>{{ Trans('customers.menu') }}</th>
      <th>{{ Trans('invoices.total') }}</th>
      <th>{{ Trans('invoices.recieved') }}</th>
      <th>{{ Trans('invoices.created_at') }}</th>
      @if(UserRole::has('detail_invoice'))
      <th style="width:20%;">{{ Trans('dashboard.crud.actions') }}</th>
      @endif
    </tr>
  </thead>
  <tbody>
      @foreach($invoices as $invoice)
        <tr>
          <td>{{ InvoiceHelper::convertInvoiceNumber($invoice->id) }}</td>
          <td>
            @if ($invoice->c_id) 
              {{ $invoice->first_name }} {{ $invoice->last_name}} ({{$invoice->tel}})
            @else 
              {{ trans('customers.general') }}
            @endif
          </td>
          <td>{{ money($invoice->total) }}</td>
          <td>{{ money($invoice->recieved) }}</td>
          <td>{{ $invoice->created_at }}</td>
          @if(UserRole::has('detail_invoice'))
          <td>
            <a href='{{ route('invoices.show', $invoice->id)}}' class="btn btn-xs btn-primary"><i class="fa fa-th-list"></i> {{ Trans('dashboard.others.see') }}</a>
            <a href='{{ route('printinvoice', [$invoice->id, 'type=a5'])}}' target="_blank" class="btn btn-xs btn-primary"><i class="fa fa-print"></i> Print</a>
            <a href="#" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#myModal{{$invoice->id}}"><i class="fa fa-trash"></i> {{Trans("dashboard.crud.remove")}}</a>
            @include('layouts.includes.modals.danger', ['model' => $invoice,'toRoute'=>'deleteInvoice','attribute'=>'id'])
          </td>
          @endif
        </tr>
      @endforeach

  </tbody>
</table>
