<div class="box">
  <div class="box-header with-border">
      <h3 class="box-title"><i class="fa fa-dollar"></i> {{ trans('invoices.payment') }}</h3>
  </div>
  <div class="box-body">
    @if ($invoice->deposit > 0)
    {{ Form::open(['route' => 'postDeposit', 'class' => 'form-horizontal']) }}
    {{ Form::hidden('invoice_id', $invoice->id) }}
    <div class="form-group">
      <label for="payable" class="col-md-3 control-label">{{ trans('invoices.payable') }}</label>
      <div class="col-md-6">
        {{ Form::number('payable', null, [
            'class' =>  'form-control',
            'required'  =>  'required',
            'step'  =>  'any',
            'placeholder'   =>  trans('invoices.payable')
        ])}}
      </div>
    </div>
    <div class="form-group">
      <label for="note" class="col-md-3 control-label">{{ trans('invoices.note') }}</label>
      <div class="col-md-6">
          {{ Form::textarea('note', null, [
              'class' =>    'form-control',
              'placeholder' =>  trans('invoices.note'),
              'rows'    =>  '2'
          ])}}
      </div>
    </div>
    <div class="form-group">
        <div class="col-md-offset-3 col-md-6">
          <button type="submit" class="btn btn-success">{{ trans('invoices.pay') }}</button>
        </div>
    </div>

    {{ Form::close()}}
@endif
    <table class="table table-striped table-bordered">
      <thead>
        <tr>
          <th style="width:25%">{{ Trans('invoices.created_at') }}</th>
          <th>{{ Trans('invoices.payable_recieved') }}</th>
          <th>{{ Trans('invoices.changed') }}</th>
          <th>{{ Trans('invoices.note') }}</th>
        </tr>
      </thead>
      <tbody>
        @if(count($payables))
          @foreach($payables as $payable)
            <tr>
              <td>{{ $payable->created_at }}</td>
              <td>{{ money($payable->amount) }}</td>
              <td>{{ money($payable->changed) }}</td>
              <td>{{ $payable->note }}</td>
            </tr>
          @endforeach
      @else
        <tr>
          <td colspan="4" class="text-center">
            No History
          </td>
        </tr>
      @endif
      </tbody>
    </table>
  </div>
</div>
