@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('invoices.menu') }}
      <small>{{ trans('invoices.draft')}}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active"><a href="{{ route('invoices.index') }}"><i class="fa fa-info"></i> {{ Trans('invoices.menu') }}</a></li>
      <li class="active"><a href="#">{{ Trans('dashboard.others.show_all')}}</a></li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    @include('layouts.includes.message')
    <div class="row">
      <div class="col-md-12">
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title"> {{ Trans('dashboard.others.show_all')}}</h3>
            @if(!empty($invoices) && count($invoices))
            {{ Form::open(['method' => 'DELETE', 'route' => 'delete.draftInvoices']) }}
                {{ Form::submit('Delete All', ['class' => 'btn btn-xs btn-danger pull-right']) }}
            {{ Form::close() }}
            @endif
          </div>
          <div class="box-body">
            <table class="table table-table-striped table-bordered" id="example2">
              <thead>
                <tr>
                  <th>#</th>
                  <th>{{ trans('invoices.total')}}</th>
                  <th>{{ trans('invoices.status')}}</th>
                  <th>{{ trans('invoices.created_at')}}</th>
                  <th>{{ trans('dashboard.crud.actions')}}</th>
                </tr>
              </thead>
              <tbody>
                @foreach($invoices as $invoice)
                  <tr>
                    <td>{{ $invoice->id }}</td>
                    <td>{{ $invoice->total }}</td>
                    <td>{{ $invoice->status }}</td>
                    <td>{{ $invoice->created_at }}</td>
                    <td><a href="#" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#myModal{{$invoice->id}}">{{Trans("dashboard.crud.remove")}}</a>
                    @include('layouts.includes.modals.danger', ['model' => $invoice,'toRoute'=>'delete.draft','attribute'=>'id'])</td>
                  </tr>
                @endforeach

              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </section>
@endsection
@section('addJs')
<script>
  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": true,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>
@endsection
