@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('invoices.menu') }}
      <small>{{ Trans('invoices.cancel_order') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active"><a href="{{ route('invoices.index') }}"><i class="fa fa-info"></i> {{ Trans('invoices.menu') }}</a></li>
      <li class="active"><a href="#">{{ Trans('dashboard.others.show_all')}}</a></li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    @if(Session::has('message'))
      <p class="alert alert-warning">
        {{ Trans(Session::get('message')) }}
      </p>
    @endif
    <div class="row">
      <div class="col-md-3">
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">{{ trans('invoices.menu') }}</h3>
          </div>
          <div class="box-body">
            {{ Form::open(['method' => 'get']) }}
            <?php
              $value = (Input::get('search')) ? Input::get('search') : null;
             ?>
            <div class="form-group">
              {{ Form::text('search', $value, [
                'class' => "form-control",
                'placeholder' => trans('invoices.enter_id')
                ])}}

            </div>
            <div class="pull-right">
              <button type="submit" class="btn btn-primary">{{ trans('dashboard.words.search')}}</button>
            </div>
            {{ Form::close() }}
          </div>
        </div>
      </div>
      <div class="col-md-9">
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">
              @if(!empty(Input::get('search')))
                Search Invoice ID <b>{{ Input::get('search') }}</b>
              @else
                Invoice ID
              @endif
            </h3>

          </div>
          <div class="box-body">

            @if(isset($orders) && isset($invoice))
              <table class="table table-striped table-bordered">
                <thead>
                  <tr>
                    <th>{{ Trans('products.sku') }}</th>
                    <th>{{ Trans('invoices.total') }}</th>
                    <th>{{ Trans('invoices.pay') }}</th>
                    <th>{{ Trans('invoices.changed') }}</th>
                    <th>{{ Trans('invoices.created_at') }}</th>
                    <th>{{ Trans('dashboard.crud.actions')}}</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td>{{ $invoice->id }}</td>
                    <td>{{ money($invoice->total) }}</td>
                    <td>{{ money($invoice->recieved) }}</td>
                    <td>{{ money($invoice->changed) }}</td>
                    <td>{{ $invoice->created_at }}</td>
                    <td>
                      {{ Form::open(['route' => ['deleteInvoice', $invoice->id], 'method' => 'DELETE']) }}
                        <button type="submit" name="comfirm_order" class="btn btn-xs btn-danger"><i class="fa fa-trash"></i> Cancel Invoice</button>
                      {{ Form::close() }}
                    </td>
                  </tr>
                </tbody>
              </table>
              <br>
            <table class="table table-striped table-bordered" id='example2'>
              <thead>
                <tr>
                  <th>{{ Trans('products.id') }}</th>
                  <th>{{ Trans('products.sku') }}</th>
                  <th>{{ Trans('products.name') }}</th>
                  <th>{{ Trans('products.amount') }}</th>
                  <th>{{ Trans('products.price') }}</th>
                </tr>
              </thead>
              <tbody>
                  <?php
                  $i = 1;
                  $total = 0;
                  ?>
                  @foreach($orders as $order)
                    <?php $total += $order->price; ?>
                    <tr>
                      <td>{{ $i }}</td>
                      <td>{{ $order->sku }}</td>
                      <td>{{ getField('Product', 'id', $order->product_id, 'name') }}</td>
                      <td>{{ $order->amount }}</td>
                      <td>{{ money($order->price) }}</td>
                    </tr>
                    <?php $i++; ?>
                  @endforeach
                  <tr>
                    <td colspan="4" class="text-right">Total Price</td>
                    <td>{{ money($total) }}</td>
                  </tr>
                  <tr>
                    <td colspan="4" class="text-right">Tax</td>
                    <td>{{ $invoice->tax }}%</td>
                  </tr>
                  <tr>
                    <td colspan="4" class="text-right">Total Price</td>
                    <td>{{ money($invoice->total) }}</td>
                  </tr>
              </tbody>
            </table>
          @else
            <p>
             No invoice found
            </p>
          @endif
          </div>
        </div>
      </div>
    </div>
  </section>
@endsection
