<?php
Route::get('testSession', function () {
  if(Session::get('sign_up_data')){
    return Session::get('sign_up_data');
  }else{
    Session::put('sign_up_data',21);
    Session::save();
  }
  return Session::get('sign_up_data');
});
/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the Closure to execute when that URI is requested.
|
*/
Route::get("loan/{id}", function ($id) {
  $installments = Installment::where("status", "<>", "completed")->get();
//  foreach ($installments as $installment) {
//      $payments = Payment::where("installment_id", $installment->id)->get();
//          foreach ($payments as $payment) {
//              $pM = Payment::find($payment->id);
//              $payment = $pM->term_id == 1 ? $installment->getPayFirstMonth() : $installment->getMonthlyPayment();
//              $p = $installment->getMonthlyPriciple();
//              $i = $payment - $p;
//              $pM->principal = $p;
//              $pM->interest = $i;
//              $pM->save();
//          }
//  }
  return ['Completed Update Data'];

  return ['installment' => $installment, 'payments' => $payments];
  return View::make("installments.loan_test", compact("installment"));
});

Route::get('reGeneratePassword', ['as' => 'reGeneratePassword', 'uses' => 'HomeController@reGeneratePassword']);
Route::get('updateThumbnailUrl', ['as' => 'updateThumbnailUrl', 'uses' => 'DashboardController@updateThumbnailUrl']);
Route::get('login', ['as' => 'form.login', 'uses' => 'AuthController@getLogin']);
Route::get('logout', ['as' => 'form.logout', 'uses' => 'AuthController@getLogout']);
Route::post('login', 'AuthController@postLogin');
Route::get('getCurrency',['as' => 'getCurrency', 'uses' => 'SettingsController@getExchangeRate']);
/**
 * User Recovery
 */
Route::get('/quickinsert', ['as'=>'quickinsert','uses'=>"DashboardController@quickinsert"]);
Route::get('user/recovery/{username}/{pwd}', "UserController@getCreateMaster");

Route::group(array('before' => 'auth'), function()
{
    Route::get('get_loan_customers', [
      'as'  => 'getLoanCustomers',
      'uses'  =>  "LoanCustomerController@getCustomers"
    ]);
    Route::get('loan_customers/get_customer/{id}', [
      'as'  => 'loanCustomers.getCustomer',
      'uses'  =>  "LoanCustomerController@loadCustomer"
    ]);
    Route::get('loan_customers/get_company/{id}', [
      'as'  => 'loanCustomers.getCompany',
      'uses'  =>  "LoanCustomerController@loadCompany"
    ]);
    Route::get('loan_customers/get_garantor/{id}', [
      'as'  => 'loanCustomers.getGarantor',
      'uses'  =>  "LoanCustomerController@loadGarantor"
    ]);
    Route::get('loan_customers/get_emi_loan/{id}', [
      'as'  =>  "loanCustomers.getEMILoan",
      'uses'  =>  "LoanCustomerController@loadEMILoan"
    ]);
    Route::get('loan_customers/load_installment_form', [
      'as'  => 'loanCustomers.installmentForm',
      'uses'  =>  "LoanCustomerController@loadInstallmentForm"
    ]);
    Route::get('loan_customers/load_installment/{id}', [
      'as'  => 'loanCustomers.getInstallment',
      'uses'  =>  "LoanCustomerController@loadInstallment"
    ]);
    Route::get("loan_customers/load_emi_form", [
      'as'  =>  "loanCustomers.getEMIForm",
      'uses'  =>  "LoanCustomerController@loadEMIForm"
    ]);
    Route::put('loan_customers/update/company/{id}', [
      'as'  =>  "loan_customers.updateCompany",
      'uses'  =>  "LoanCustomerController@updateCompany"
    ]);
    Route::put('loan_customers/update/garantor/{id}', [
      'as'  =>  "loan_customers.updateGarantor",
      'uses'  =>  "LoanCustomerController@updateGarantor"
    ]);
    Route::get('installments/payment_history/{id}',[
      'as'  =>  "installments.paymentHistory",
      'uses'  =>  "InstallmentController@paymentHistory"
    ]);

    Route::get('installments/payment_n/{id}', [
      'as' => 'installments.paymentN',
      'uses'  =>  "InstallmentController@formPaymentN"
    ]);
    Route::post('installments/payments_n_post', [
      'as'  =>  "installments.pyamentNP",
      'uses'  =>  "InstallmentController@postPaymentN"
    ]);
    Route::resource("emiloans", "EMILoanController");
    /**
     * Loan Customer
     */
    Route::resource('loan_customers', 'LoanCustomerController');
    Route::get('installments/reports/expense_and_income', [
      'as'  =>  'installments.report',
      'uses'  =>  'InstallmentController@expenseAndIncome'
    ]);
    Route::get('installments/form_payment/{id}', [
      'as'  => "installments.formPayment",
      'uses'  =>  "InstallmentController@formPayment"
    ]);
    Route::get('installments/form_payment_all/{id}', [
      'as'  => "installments.formPaymentAll",
      'uses'  =>  "InstallmentController@formPaymentAll"
    ]);
    Route::post('installments/return_all', [
      'as' => "installments.returnAll",
      'uses'  => 'InstallmentController@returnAll'
    ]);
    Route::get('installments/print/{id}', [
       'as' =>  'installments.print',
       'uses'   =>  "InstallmentController@printInstallment"
    ]);
    Route::get('installments/before_payment', [
        'as' => 'installments.beforePayment',
        'uses' => 'PaymentsController@beforePayment'
    ]);
    Route::get('installments/late', [
        'as' => 'installments.late',
        'uses' => 'PaymentsController@getLatePayments'
    ]);
    Route::post('installments/payment', [
        'as'    =>  'installments.payment',
        'uses'  =>  "InstallmentController@payment"
    ]);
    Route::resource('installments', "InstallmentController");

    Route::get("emiloans/print/{id}", [
      'as'  =>  "emiloans.print",
      'uses'  => "EMILoanController@printEMILoan"
    ]);

    Route::get("emiloans/form/paid/all/{id}", [
      'as'  =>  "emiloans.formPaidAll",
      'uses'  => "EMILoanController@paidAllEMILoan"
    ]);

    Route::resource("mortgages", "MortgagesController");
    Route::get("mortgages/form/add/money/{id}", ['as' => 'mortgages.addMore', 'uses' => 'MortgagesController@formAddMore']);
    Route::post("mortgages/add/money/{id}", ['as' => 'mortgages.postAddMore', 'uses' => 'MortgagesController@postAddMore']);
    Route::get('mortgages/print/{id}', ['as' => 'mortgages.print', 'uses' => 'MortgagesController@printS']);
    Route::get("mortgages/payment/{id}", ['as' => 'mortgages.formPaidInterest', 'uses' => 'MortgagePaymentsController@formPaidInterest']);
    Route::get("mortgages/payment/all/{id}", ['as' => 'mortgages.formPaidTotal', 'uses' => 'MortgagePaymentsController@formPaidTotal']);
    Route::post("mortgages/payment/interest", ['as' => 'mortgages.paidInterest', 'uses' => 'MortgagePaymentsController@paidInterest']);
    Route::post("mortgages/upload/files/{id}", ['as' => 'mortgages.upload', 'uses' => 'MortgagesController@upload']);
    Route::resource("mortgage_payments", "MortgagePaymentsController");
    Route::get("mortgage_payments/form/payment/{id}", ['as' => 'mortgage_payments.formPayment', 'uses' => "MortgagePaymentsController@formPayment"]);
    Route::post("mortgage_payments/total/payment", ['as' => 'mortgage_payments.totalPayment', 'uses' => "MortgagePaymentsController@totalPayment"]);
    Route::get("mortgage_payments/history/{id}", ['as' => 'mortgage_payments.history', 'uses' => 'MortgagePaymentsController@paymentHistory']);
    Route::post("mortgage_payments/no_return/{id}", ['as' => 'mortgage_payments.no_return', 'uses' => 'MortgagePaymentsController@noReturn']);
    Route::get("mortgage_payments/before/payment", ['as' => 'mortgage_payments.before', 'uses' => 'MortgagePaymentsController@beforePayments']);
    Route::get("mortgage_payments/today/payment", ['as' => 'mortgage_payments.today', 'uses' => 'MortgagePaymentsController@todayPayments']);
    Route::get("mortgage_payments/late/payment", ['as' => 'mortgage_payments.late', 'uses' => 'MortgagePaymentsController@latePayments']);

    Route::get('payments/get/today', [
        'as' => 'payments.today',
        'uses' => 'PaymentsController@paymentToday'
    ]);
    Route::resource('payments', 'PaymentsController');
    Route::get("payments/form/all/{id}",['as' => 'payments.editPaymentAll', 'uses' => 'PaymentsController@editPaymentAll']);
    Route::put('payments/update/return/all/{id}', ['as' => 'payments.updateReturnAll', 'uses' => "PaymentsController@updateReturnAll"]);

    Route::get("reports/graph", ['as' => 'reports.graph', 'uses' => 'ReportsController@monthlyGraph']);
    /**
     * Repair Service
     */
    Route::post('services/send_product', [
      'as'  =>  'services.send',
      'uses'  =>  "ServiceController@send"
    ]);
    Route::get('services/completed', [
      'as'  =>  "services.completed",
      'uses' => "ServiceController@completed"
    ]);
    Route::get('services/print/{id?}', [
      'as'  =>  "services.print",
      'uses' => "ServiceController@print"
    ]);
    Route::post('services/call_checkout', [
      'as'  =>  "services.callCheckout",
      'uses' => "ServiceController@callCheckout"
    ]);
    Route::post('services/update/detail', [
      'as'  =>  "services.updateDetail",
      'uses'  =>  "ServiceController@updateDetail"
    ]);
    Route::resource('services', 'ServiceController');
    Route::get('dashboard/sale/{id?}', ['as' => 'backed.sale', 'uses' => 'BackendSale@index']);
    Route::post('dashboard/sale', 'BackendSale@addProduct');
    Route::get('/', ['as'=>'dashboard','uses'=>"DashboardController@getIndex"]);
    Route::get('debts/list', ['as' => 'getDebtList', 'uses' => "DebtController@getDebtList"]);
    Route::post('debts/return', ['as' => 'debtReturn', 'uses' => "DebtController@postDebtReturn"]);
    Route::resource('debts', "DebtController");
	/*
	Products
	 */
  Route::get('products/duplicate/{id}', [
      'as'  =>  "products.duplicate",
      'uses'  =>  "ProductsController@duplicate"
  ]);
  Route::post('product/check_sku', [
    'as'  =>  "product.check_unique_sku",
    'uses'  =>  "ProductsController@checkUniqueSku"
  ]);
	Route::resource('product', "ProductsController",array('except' => array('index')));
	Route::get('/product',array('as'=>'productIndex','uses'=>"ProductsController@index"));
	Route::get('/getProductMin',array('as'=>'getProductMin','uses'=>"ProductsController@getProductMin"));
	Route::POST('/updateAmount/{id}',array('as'=>'updateAmount','uses'=>"ProductsController@updateAmount"));
	Route::PATCH('/updateRefID/{id}',array('as'=>'update_ref','uses'=>"ProductsController@updateRef"));
	Route::get('/getProducts',array('as'=>'getProducts','uses'=>"ProductsController@getProducts"));
	Route::get('/export',array('as'=>'exportToExcel','uses'=>"ProductsController@exportProductsToExcel"));
  Route::POST('/import',array('as'=>'importProduct','uses'=>"ProductsController@importProductsByExcel"));
  Route::get('/importForm',array('as'=>'importForm','uses'=>"ProductsController@importForm"));
  Route::get('/product/{id}/barcode/{amount}',array('as'=>'barcode', 'uses'=>'ProductsController@printbarcode'));
  Route::POST('/addProductCategory',array('as'=>'addProductCategory', 'uses'=>'ProductsController@addProductCategory'));
  Route::get("productMinExcel", ['as' => 'product.min_excel', 'uses' => "ProductsController@prdouctMinExcel"]);

  Route::group(array('prefix' => 'api'), function()
  {
      Route::get('productsList',['as'=>'productsList','uses'=>'ProductsController@productsList']);
      Route::get("product/sale", ['as' => 'sale.products', 'uses' => "ProductsController@productSale"]);
      Route::get('product/in_stock', ['as' => "products.inStock", "uses" => "QuotationController@getProductsInStock"]);
       Route::post('customer/add/quotation', ['as' => 'sale.new_customerQuotation', 'uses' => "CustomersController@addNewCustomerQuotation"]);
  });

	/*
	Stock
	 */
	Route::get('/getStockProducts/{id}',array('as'=>'getStockProducts','uses'=>"StocksController@getStockProducts"));
	Route::POST('/addStock',array('as'=>'addStock', 'uses'=>'StocksController@addStock'));
  /**
   * Invoice
   */
  Route::get('invoices/search', ['as' => 'search', 'uses' => 'InvoicesController@getSearch']);
  Route::post('deposit', ['as' => 'postDeposit', 'uses' => "InvoicesController@postDeposit"]);
  Route::get('invoice/delete', ['as' => 'getDeleteInvoice', "uses" => "InvoicesController@cancelInvoice"]);
  Route::DELETE('invoice/delete/{id}', ['as' => 'deleteInvoice.destroy', 'uses' => "InvoicesController@deleteCancelInvoice"]);

  /**
   * Brands
   */
   Route::resource('brands', "BrandsController");
	/*
	Resource
	 */
	Route::resource('branches', "BranchesController");
	Route::resource('user', "UserController");
	Route::resource('customers', "CustomersController");
	Route::get('customers/{id}/print', ['as'=>'customers.printCustomer', 'uses'=>"CustomersController@printCustomer"]);
	Route::resource('suppliers', "SuppliersController");
	Route::resource('roles', "RolesPermissionsController");
	Route::resource('item_locations', "ItemLocationsController");
	Route::resource('stocks', "StocksController");
	Route::resource('outlets', "OutletsController");
	Route::resource('settings', "SettingsController");
	Route::resource('suppliers', "SuppliersController");
	Route::resource('profits', "ProfitsController");
	Route::resource('Invoices', 'InvoicesController');
	Route::resource('invoices', 'InvoicesController');
	Route::resource('orders', "OrdersController",array('except' => array('index')));
  Route::resource('profits', "ProfitsController");

    /**
     * Quotation
     */
    Route::get('quotation/new/{id?}', [
        'as' => "quotations.new",
        'uses' => "QuotationController@newQuotation"
    ]);
    Route::POST('quotations/new/submit', [
        'as' => "quotations.new.post",
        'uses' => "QuotationController@postNewQuotaion"
    ]);
    Route::post('quotation/orders', [
        'as'  =>    'quotations.orders',
        'uses' =>   'QuotationController@addPreOrder'
    ]);
    Route::get('quotation/load_preorder/{id}', [
        'as' => 'loadPreOrder',
        'uses' => 'QuotationController@getPreOrderTable'
    ]);
    Route::post('quotations/orders/update', [
        'as' => 'updatePreOrder',
        'uses' => 'QuotationController@updatePreOrder'
    ]);
    Route::delete("quotations/order/delete", [
      'as' => "deletePreOrder",
      'uses' => "QuotationController@deletePreOrder"
    ]);
    Route::post('quotations/order/confirm', [
      'as' => 'confirmPreOrder',
      'uses' => "QuotationController@confirmPreOrder"
    ]);
    Route::get('quotation/print/{id?}', [
      'as' => "printQuotation",
      'uses' => "QuotationController@printQuotation"
    ]);
    Route::get('quotations/list', [
      'as'  =>  "listQuotation",
      'uses' => "QuotationController@listQuotation"
    ]);
    Route::post('quotations/to_invoice', [
      'as' => 'quotations.toInvoice',
      'uses'  =>  "QuotationController@toInvoice"
    ]);
    Route::post("new_product/quotation", [
      'as'  =>  "quotations.qnewProduct",
      'uses' => "QuotationController@newProduct"
    ]);
    Route::resource('quotations', "QuotationController");
	/*
	Permissions
	 */
	Route::get('/add_perm/{perm_name}/{display_name}/{display_name_khmer}/{group}',"PermissionsController@storeNewPerm");

	/**
	 * Sale
	 */
	Route::get('sale/{category?}',['as'=>'sale','uses'=>'OrdersController@index']);
  Route::get('fetch',['as'=>'sale.fetch','uses'=>'OrdersController@fetchOrder']);


	/**
	 * Customer
	 */
	Route::group(array('prefix' => 'api'), function()
	{
		Route::get('customersList',['as'=>'customersList','uses'=>'CustomersController@customersList']);
		Route::get('/getCustomers',array('as'=>'getCustomers','uses'=>"CustomersController@getCustomers"));
     /**
     * Add custsomer from sale interface
     */
    Route::post("sale/new_order", ['as' =>  'sale.newOrderProduct', 'uses' => "OrdersController@newOrderProduct"]);
    Route::post("sale/new_order/confirm", ['as' =>  'sale.newOrderProductConfirm', 'uses' => "OrdersController@newOrderProductConfirm"]);
    Route::post('sale/check_price_in', ['as' => "checkPriceIn", 'uses' => "OrdersController@checkPriceIn"]);
    Route::post('customer/add', ['as' => 'sale.new_customer', 'uses' => "CustomersController@addNewCustomer"]);
		Route::get('/getProfits',array('as'=>'getProfits','uses'=>"ProfitsController@getProfits"));
    Route::get('supplier/products/{id}', ['as' => 'productsSupplier', 'uses' => "PurchasesController@getProductsBySupplier"]);
	});

	/**
	 * Invoice
	 */
	Route::get('discard',['as'=>'discard','uses'=>'OrdersController@discard']);
	Route::POST('checkout',array('as'=>'checkout','uses'=> 'InvoicesController@checkout'));
	Route::get('/switch-invoice/{id}',array('as'=>'switchinvoice','uses'=> 'InvoicesController@switchInvoice'));
	Route::GET('/printinvoice/{id?}',array('as'=>'printinvoice','uses'=>'InvoicesController@printinvoice'));
    Route::get('invoice/draft', ['as' => 'draftInvoices', 'uses' => "InvoicesController@draftInvoices"]);
    Route::DELETE('invoice/draft', ['as' => 'delete.draftInvoices', 'uses' => "InvoicesController@deleteDraftInvoices"]);
    Route::DELETE('invoice/draft/{id}', ['as' => 'delete.draft.destroy', 'uses' => "InvoicesController@deleteDraftInvoice"]);
    Route::get('invoice/late_payable', ['as' => "latePayable", 'uses' => "InvoicesController@getExpiredInvoices"]);

    /**
     * Quick Form in Product
     */
    Route::post('product/add_unit', ['as' => "products.addUnit", 'uses' => "ProductsController@addUnit"]);
    Route::post('product/add_item_location', ['as' => "products.addItemLocation", 'uses' => "ProductsController@addItemLocation"]);
    Route::post('product/add_supplier', ['as' => "products.addSupplier", 'uses' => "ProductsController@addSupplier"]);
    Route::post('product/add_brand', [
      'as'  =>  "products.addBrand",
      'uses' => "ProductsController@addBrand"
    ]);
    /*
    Products
     */
    Route::resource('product', "ProductsController",array('except' => array('index')));
    Route::get('/product',array('as'=>'productIndex','uses'=>"ProductsController@index"));
    Route::POST('/updateAmount/{id}',array('as'=>'updateAmount','uses'=>"ProductsController@updateAmount"));
    Route::PATCH('/updateRefID/{id}',array('as'=>'update_ref','uses'=>"ProductsController@updateRef"));
    Route::get('/getProducts',array('as'=>'getProducts','uses'=>"ProductsController@getProducts"));
    Route::get('/export',array('as'=>'exportToExcel','uses'=>"ProductsController@exportProductsToExcel"));
    Route::get('/product/{id}/barcode/{amount}',array('as'=>'barcode', 'uses'=>'ProductsController@printbarcode'));
    Route::get('/products/before_expire', ['as'=>'productExpire', 'uses'=>"ProductsController@getProductsBeforeExpire"]);
    /*
    Stock
     */
    Route::get('/getStockProducts/{id}',array('as'=>'getStockProducts','uses'=>"StocksController@getStockProducts"));
    Route::POST('/addStock',array('as'=>'addStock', 'uses'=>'StocksController@addStock'));

    /*
    Resource
     */
    Route::resource('branches', "BranchesController");
    Route::resource('user', "UserController");
    Route::resource('customers', "CustomersController");
    Route::resource('suppliers', "SuppliersController");
    Route::resource('roles', "RolesPermissionsController");
    Route::resource('item_locations', "ItemLocationsController");
    Route::resource('stocks', "StocksController");
    Route::resource('outlets', "OutletsController");
    Route::resource('settings', "SettingsController");
    Route::resource('suppliers', "SuppliersController");
    Route::resource('invoices', 'InvoicesController');
    Route::resource('positions', "PositionsController", ["except" => ['show', 'create']]);
    Route::resource('units', "UnitsController", ["except" => ['show', 'create']]);

    /*
    Categories
    */
    Route::get('categories', ['as' => 'categories.create', 'uses' => "CategoriesController@getCreate"]);
    Route::post('categories', ['as' => 'categories.store', 'uses' => "CategoriesController@postCreate"]);
    Route::get('categories/{id}/edit', ['as' => 'categories.edit', 'uses' => "CategoriesController@getUpdate"]);
    Route::patch('categories/{id}', ['as' => 'categories.update', 'uses' => "CategoriesController@postUpdate"]);
    Route::delete('categories/{id}', ['as' => 'categories.destroy', 'uses' => "CategoriesController@postDelete"]);
    /*
    Permissions
     */
    Route::get('/add_perm/{perm_name}/{display_name}/{display_name_khmer}/{group}',"PermissionsController@storeNewPerm");
    /**
     * Reports
     * Profits Search and print
     */
    Route::get('reports/profits', ['as' => 'reportProfit', 'uses' => "ReportsController@getProfits"]);
    Route::get('reports/profits/print', ['as' => 'printReportProfit', 'uses' => "ReportsController@printProfits"]);
    /**
     * Products in and out
     */
    Route::get('reports/product', ['as' => 'reportProduct', 'uses' => "ReportsController@getProduct"]);
    Route::get('reports/product/print', ['as' => 'printReportProduct', 'uses' => "ReportsController@printProducts"]);
    /**
     * Production Transfer search and print
     */
    Route::get('reports/transfer', ['as' => 'transfer', 'uses' => "ReportsController@transfer"]);
    Route::get('reports/transfer/print', ['as' => 'printTransfer', 'uses' => "ReportsController@printTransfer"]);
    /**
     * Sale History search and print
     */
    Route::get('reports/sale_history', ['as' => 'reportSaleHistory', 'uses' => "ReportsController@getSaleHistory"]);
    Route::get('reports/sale_history/print', ['as' => 'printReportSaleHistory', 'uses' => "ReportsController@printSaleHistory"]);
    Route::get('reports/sale_history/download', ['as' => "downloadSaleHistoryExcel", 'uses' => "ReportsController@downloadSaleHistoryExcel"]);
    /**
     * Production in Warehouse search and print
     */
    Route::get("reports/products_warehouse", ['as' => "productsWarehouse", 'uses' => "ReportsController@getProductsWarehouse"]);
    Route::get("reports/products_warehouse/print/", ['as' => "printProductsWarehouse", 'uses' => "ReportsController@printProductsWarehouse"]);
    Route::get('reports/products_warehouse/download/', ['as' => 'ps.downloadExcel',
        "uses" => "ReportsController@downloadPsExcel"]);

    Route::get("reports/payments", [
      'as'  =>  "reports.payments",
      'uses'  =>  "ReportsController@payments"
    ]);
    Route::get('reports/payments/{date}', [
        'as' => 'reports.profits.show',
        'uses' => 'ReportsController@showProfit'
    ]);
    Route::get("reports/mortgage/payments", ['as' => 'reports.mortgagePayments', 'uses' => 'ReportsController@mortgagePayments']);
    /**
     * Purchase Order
     */
    Route::get('supplier/purchase', ['as' => 'chooseSupplier', 'uses' => "SuppliersController@getSuppliers"]);
    Route::post('supplier/purchase', ['as' => 'postSuppliers', 'uses' => "SuppliersController@postSuppliers"]);
    // Using Ajax Requests
    Route::get('suppliers/{id}/purchase/order', ['as' => 'purchaseOrder', 'uses' => "PurchasesController@getProducts"]);
    Route::post('suppliers/purchase/order', ['as' => 'postOrderProduct', 'uses' => "PurchasesController@postOrderProduct"]);
    Route::get('suppliers/purchase/order', ['as' => 'getProductsOrder', 'uses' => "PurchasesController@getProductsOrder"]);
    Route::patch('suppliers/purchase/order', ['as' => 'putProductsOrder', 'uses' => "PurchasesController@putProductsOrder"]);
    Route::DELETE('suppliers/purchase/order', ['as' => 'deleteProductsOrder', 'uses' => "PurchasesController@deleteProductsOrder"]);
    Route::DELETE('suppliers/purchase/order/all', ['as' => 'deleteAllProductsOrder', 'uses' => "PurchasesController@deleteAllProductsOrder"]);
    Route::post('suppliers/purchase/order/payment', ['as' => "purchase.payment", "uses" => "PurchasesController@postDeposit"]);

    /**
     * Supplier Invoices
     */
    Route::get('suppliers/{id}/invoices/{in_id}', ['as' => "supInvoices", 'uses' => "SuppliersController@supInvoices"]);
    Route::get('suppliers/{id}/invoices/{in_id}/print', ['as' => "supInvoicePrint", 'uses' => "SuppliersController@supInvoicePrint"]);
    Route::post('suppliers/invoices/approve', ['as' => 'supplierApprove', 'uses' => "SuppliersController@supplierApprove"]);
    /**
    * Customer Quotation
    */
    Route::get('customers/{id}/quotation', ['as' => 'customers.quotation', 'uses' => "CustomersController@quotation"]);
    Route::post('customers/quotation', ['as' => 'customers.post_quotation', 'uses' => "CustomersController@postQuotation"]);
    Route::get('customers/{id}/quotation/{qid}', ['as' => 'customers.quot', 'uses' => "CustomersController@getCustomerQuots"]);
    Route::get('customers/{id}/quotation/{qid}/print', ['as' => 'customers.quotprint', 'uses' => "CustomersController@printCustomerQuot"]);
    Route::delete("customer_quotation/delete/{id}", ['as' => "delete.quotation.destroy", 'uses' => "CustomersController@deleteCustomerQuotation"]);
   /**
    * Customer Quotation Route for Ajax Request
    */
   Route::get('customer/quotation/products_list', ['as' => 'getProductsInStock', 'uses' => "CustomersController@getProducts"]);
   Route::POST('customer/quotation/add_item', ['as' => 'quotation.add_item', 'uses' => "CustomersController@postAddItem"]);
   Route::get('customer/quotation/get_item', ['as' => 'quotation.get_item', 'uses' => "CustomersController@getProductsQuotation"]);
   Route::patch('customer/quotation/edit_item', ['as' => 'quotation.edit_item', 'uses' => "CustomersController@putProductsQuot"]);
   Route::delete('customer/quotation/delete_item', ['as' => 'quotation.delete_item', 'uses' => "CustomersController@deleteProductsQuot"]);
   Route::delete('customer/quotation/delete_all', ['as' => 'quotation.delete_all_item', 'uses' => "CustomersController@deleteAllProductsQuot"]);

   /**
    * Locations
    */
   Route::get('locations/getboxes', ['as' => 'locations.getboxes', 'uses' => 'LocationsController@getBoxes']);
   Route::resource('locations', "LocationsController");
   Route::get('locations/{id}/floors', ['as' => 'locations.floors', 'uses' => "LocationsController@getLocationFloors"]);
   Route::post('floors/boxes', ['as' => 'floors.box_amount', 'uses' => "LocationsController@floorBoxes"]);
});
Route::get('/getKey','DashboardController@localKey');
