<?php
use Illuminate\Auth\UserTrait;
use Illuminate\Auth\UserInterface;
use Illuminate\Auth\Reminders\RemindableTrait;
use Illuminate\Auth\Reminders\RemindableInterface;

class User extends Eloquent implements UserInterface, RemindableInterface {

	use UserTrait, RemindableTrait;
	public $timestamps = true;
  public static $auth_rules = [
    'username' => 'required',
    'password' => 'required'
  ];
	protected $fillable = array('first_name', 'last_name', 'username', 'remember_token', 'address', 'tel', 'email', 'position_id', 'allow_ip', 'session_id', 'status', 'role_id','sex','date_of_birth','photo','id_number','branch_id','password','stock_id');
	/**
	 * Set Rule for validation
	 * @var array
	 */
	public static $rules = array(
			'first_name' 	=> 'required',
			'last_name' 	=> 'required',
			'username' 		=> 'required|unique:users',
			'password' => 'required',
            'email' => 'unique:users',
            'tel' => 'unique:users'
		);
	/**
	 * Get Upload Path
	 * @return string Path store image upload
	 */
	public static function getUploadPath()
	{
		return "uploads/users/";
	}
	public function products()
	{
		return $this->hasMany('Products');
	}

	public function branch()
	{
		return $this->belongsTo('Branches');
	}
	public function scopeMaster($query)
  {
    return $query->whereRoles('master');
  }
  public function fullName() {
    return $this->first_name . ' ' .$this->last_name;
  }

	public function getCreateMaster()
	{
		$master = Role::where('role_name', "Master")->first();

	  if (empty($master)) {
	    $role = new Role;
	    $role->role_name = "Master";
	    $role->description  = "Developer";
	    $role->save();

	  }
	  return $master;
	}
}
