<?php

class Supplier extends Eloquent {

	protected $table = 'Suppliers';
	public $timestamps = true;
	public static $rules = [
		'company_name'	=> 'unique:suppliers',
		'company_email'	=> 'unique:suppliers',
		'tel'	=> 'unique:suppliers',
		'contact_tel'	=> 'unique:suppliers',
		'contact_email'	=> 'unique:suppliers'
	];

	protected $fillable = ['company_name', 'contact_name', 'contact_tel', 'address', 'tel', 'company_email', 'contact_email', 'contact_photo', 'logo', 'position_id'];

	public static $uploadPath = "/uploads/suppliers/";

	public function products()
	{
		return $this->hasMany('Suppliers');
	}
	public function position ()
	{
		return $this->belongsTo('Position');
	}

	public static function upload($name) {
		if (Input::hasFile($name)) {
			$path = public_path() . self::$uploadPath;
			$file =  Input::file($name);
			$filename = uniqid() . '.' . $file->getClientOriginalExtension();
			Input::file($name)->move($path, $filename);
			return \Config::get('app.ip') ."uploads/suppliers/" .$filename;
		} else {
			return \Config::get('app.ip').'uploads/none.jpg';
		}
	}
}
