<?php
/**
 * Report Class
 * @package default
 * @author Sok Kimsoeurn <sokkimsoeurn@gmail.com>
 * @license MIT
 */
class Report {

  /**
   * Query Object
   * @var [type]
   */
  private $queryObj = [];
  /**
   * Sale History
   * @return object Database Object
   */
  public function saleHistory()
  {
    $this->queryObj = Product::join('outlets', 'outlets.product_id', '=', 'products.id')
                            ->join('orders as o ', 'o.product_id', '=', 'products.id')
                            ->join('invoices', 'invoices.id', '=', 'o.invoice_id')
                            ->join('users as u', 'u.id', '=', 'o.user_id')
                            ->leftJoin('productcategories as pc', 'pc.id', '=', 'products.product_category_id')
                            ->leftJoin('units', 'units.id', '=', 'products.unit_id')
                            ->select(
                              'products.sku',
                              'products.name as name_en',
                              'products.name_kh',
                              'products.price_in',
                              'o.price',
                              'o.amount',
                              'u.first_name',
            				          'pc.name',
                              'invoices.created_at',
                              'invoices.id as invoice_no'
                            )->where('o.sold', 1)
                            ->orderBy('o.created_at', 'desc');
    return $this;
  }
  /**
   * By Category
   * @param  array $id    of category
   * @return object   Database object
   */
  public function byCategory($id)
  {
    if (!empty($id) && in_array('all', $id)) return $this;
    $this->queryObj->whereIn('pc.id', $id);
    return $this;
  }
  /**
   * By Date
   * @param  string $start start date
   * @param  string $end   end date
   * @return object        Database object
   */
  public function byDate($start, $end)
  {
    $this->queryObj->whereBetween('o.created_at', [$start, $end]);
    return $this;
  }
  /**
   * By Barcode
   * @param  string $start start barcode
   * @param  string $end   end barcode
   * @return object        database object
   */
  public function byBarcode($start, $end)
  {
    $this->queryObj->whereBetween('products.sku', [$start, $end]);
    return $this;
  }
  /**
   * By Stock
   * @param  int $id    Id of Stock
   * @return object     database object
   */
  public function byStock($id)
  {
    if ($id == 'all') return $this;
    $this->queryObj->where('o.stock_id', $id);
    return $this;
  }
  public function byUserLogin($userId=null)
  {
    if (is_null($userId)) return $this;
    $this->queryObj->whereIn('u.id', $userId);
    return $this;
  }
  /**
   * Show
   * @return array     Array of objects
   */
  public function show()
  {
    return $this->queryObj->get();
  }
  /**
   * Products in Warehouse
   * @return query object
   */
  public function productsWarehouse()
  {
    $this->queryObj = Product::join('outlets as o', 'o.product_id', '=', 'products.id')
                        ->join('stocks as s', 's.id', '=', 'o.stock_id')
                        ->leftJoin('productcategories as pc', 'products.product_category_id', '=', 'pc.id')
                        ->leftJoin("users as u", 'u.id', '=', 'o.user_id')
                        ->leftJoin("units as uu", 'uu.id', '=', 'products.unit_id')
                        ->select(
                        'products.id',
                        'products.sku',
                        'products.name as name_en',
                        'products.name_kh',
                        'products.price',
                        'o.amount',
                        'products.price_wholesale',
                        'products.price_in',
                        'pc.name as category',
                        'u.first_name',
                        'products.created_at',
                        'uu.name as unit'
                        )->orderBy('products.created_at', 'desc');
    return $this;
  }

  public function productsInStock()
  {
    $this->queryObj = DB::table('products as p')
                        ->join('outlets as o', 'o.product_id', '=', 'p.id')
                        ->leftJoin('productcategories as pc', 'p.product_category_id', '=', 'pc.id')
                        ->leftJoin("users as u", 'u.id', '=', 'p.user_id')
                        ->select(
                        'p.id',
                        'p.sku',
                        'p.name as name_en',
                        'p.name_kh',
                        'p.price',
                        'p.amount',
                        'p.price_wholesale',
                        'p.price_in',
                        'pc.name as category',
                        'u.first_name',
                        'p.created_at'
                        )
                        ->orderBy('p.created_at', 'desc');
    return $this;    
  }
  /**
   * Product by Date
   * @param  date $start
   * @param  date $end
   * @return query object
   */
  public function productByDate($start, $end)
  {
    $this->queryObj->whereBetween('p.created_at', [$start, $end]);
    return $this;
  }

  public function pageLimit($number)
  {
      return $this->queryObj->paginate($number);
  }
}
