<?php

class ReceiptIncome extends Eloquent
{

    protected $fillable = [
        'receipt_id',
        'payment_name',
        'total_amount',
        'total_as_letter',
        'in_digit_of',
        'with_doc',
        'note',
        'user_id'
    ];

    public function paymentDate()
    {
        $date = new Carbon\Carbon($this->created_at);
        return $date->format('d/m/Y h:i:s');
    }

    public static function addNew($data)
    {
        $receipt = new self;
        $receipt->payment_date = $data['payment_date'];
        $receipt->receipt_id = $data['receipt_id'];
        $receipt->payment_name = $data['payment_name'];
        $receipt->total_amount = $data['recieve_amount'];
        $receipt->recieve_amount = $data['recieve_amount'];
        $receipt->total_as_letter = $data['total_as_letter'];
        $receipt->in_digit_of = $data['in_digit_of'];
        $receipt->with_doc = $data['with_doc'];
        $receipt->user_id = Auth::user()->id;
        $receipt->save();
        return $receipt->id;
    }

    public static function updateReceipt($data, $id)
    {
        $receipt = self::find($id);
        $receipt->receipt_id = $data['receipt_id'];
        $receipt->payment_name = $data['payment_name'];
        $receipt->total_amount = $data['p_amount'];
        $receipt->recieve_amount = $data['p_amount'];
        $receipt->total_as_letter = $data['total_as_letter'];
        $receipt->in_digit_of = $data['in_digit_of'];
        $receipt->with_doc = $data['with_doc'];
        $receipt->user_id = Auth::user()->id;
        $receipt->save();
        return $receipt->id;
    }

}